<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */

// Default controller
$routes->get('/', 'Home::index');

// Performance testing (REMOVE IN PRODUCTION!)
$routes->get('test-performance', 'TestPerformance::index');

// Static pages
$routes->get('testimonials', 'Home::testimonial');
$routes->get('home/exam-listing', 'Home::examListing');
$routes->get('cart', 'See::cart');
$routes->get('dev_cart', 'See::dev_cart');
$routes->get('thank-you', 'See::thank_you');
$routes->get('all-dumps', 'See::all');
$routes->get('admin_login', 'See::admin_login');

// Sitemap
$routes->get('sitemap.xml', 'Sitemap::single');

// Search
$routes->get('s', 'Search::query');
$routes->post('s', 'Search::query');

// Account routes
$routes->get('account', 'Account::index');
$routes->get('account/order/(:num)', 'Account::order/$1');
$routes->get('account/signin', 'Account::signin');
$routes->get('account/register', 'Account::register');
$routes->get('account/dashboard', 'Account::dashboard');
$routes->get('account/settings', 'Account::settings');
$routes->get('account/changepass', 'Account::changepass');
$routes->get('account/orders', 'Account::orders');
$routes->get('account/downloads', 'Account::downloads');
$routes->get('account/(:any)', 'Account::$1');
$routes->post('account/(:any)', 'Account::$1');

// Action routes (specific routes with params first so they match before (:any))
$routes->post('action/edit_exam/(:num)', '\App\Controllers\Action::edit_exam/$1');
$routes->post('action/create_exam', '\App\Controllers\Action::create_exam');
$routes->post('action/edit_page/(:num)', 'Action::edit_page/$1');
$routes->post('action/add_to_cart', 'Action::add_to_cart');
$routes->post('action/update_cart', 'Action::update_cart');
$routes->get('action/registers', 'Action::registers');
$routes->post('action/registers', 'Action::registers');
$routes->post('action/register', 'Action::register');
$routes->get('action/session/(:segment)', 'Action::session/$1');
$routes->post('action/session/(:segment)', 'Action::session/$1');
$routes->get('action/forget', 'Action::forget');
$routes->post('action/forget', 'Action::forget');
$routes->get('action/resetpass', 'Action::resetpass');
$routes->get('action/resetpass/(:segment)', 'Action::resetpass/$1');
$routes->post('action/resetpass', 'Action::resetpass');
$routes->post('action/update_profile', 'Action::update_profile');
$routes->post('action/changepass', 'Action::changepass');
$routes->post('action/usercheckout', 'Action::usercheckout');
$routes->post('action/paypal_standard_checkout', 'Action::paypal_standard_checkout');
$routes->get('action/success', 'Action::success');
$routes->get('action/cancel', 'Action::cancel');
$routes->get('action/failed', 'Action::failed');
$routes->get('action/destroy_cart', 'Action::destroy_cart');
$routes->get('action/remove_from_cart/(:segment)', 'Action::remove_from_cart/$1');
$routes->get('action/remove_coupon', 'Action::remove_coupon');
// Admin / CRUD actions (explicit routes so method-not-found does not occur)
$routes->post('action/admin_login', 'Action::admin_login');
$routes->post('action/upload', 'Action::upload');
$routes->post('action/delete', 'Action::delete');
$routes->post('action/maildata', 'Action::maildata');
$routes->post('action/edit_date', 'Action::edit_date');
$routes->post('action/update_settings', 'Action::update_settings');
$routes->post('action/update_gateways', 'Action::update_gateways');
$routes->post('action/update_menus', 'Action::update_menus');
$routes->post('action/update_sections', 'Action::update_sections');
$routes->post('action/create_coupon', 'Action::create_coupon');
$routes->post('action/create_user', 'Action::create_user');
// Category
$routes->post('action/create_category', 'Action::create_category');
$routes->post('action/edit_category/(:num)', 'Action::edit_category/$1');
$routes->get('action/delete_category/(:segment)/(:num)', 'Action::delete_category/$1/$2');
// Exam
$routes->get('action/delete_exam/(:segment)/(:num)', 'Action::delete_exam/$1/$2');
// Page
$routes->post('action/create_page', 'Action::create_page');
// Coupon
$routes->post('action/edit_coupon/(:num)', 'Action::edit_coupon/$1');
// User
$routes->post('action/edit_user/(:num)', 'Action::edit_user/$1');
$routes->get('action/delete_user/(:segment)/(:num)', 'Action::delete_user/$1/$2');
// Testimonial
$routes->get('action/delete_testimonial/(:segment)/(:num)', 'Action::delete_testimonial/$1/$2');
$routes->get('action/edit_testimonial/(:segment)/(:num)', 'Action::edit_testimonial/$1/$2');
$routes->get('action/(:any)', 'Action::$1');
$routes->post('action/(:any)', 'Action::$1');

// Admin routes
$routes->get('admin', 'Admin::index');
$routes->get('admin/exam', 'Admin::exam');                  // /admin/exam -> new
$routes->get('admin/exam/(:segment)', 'Admin::exam/$1');    // /admin/exam/{id}
$routes->get('admin/category', 'Admin::category');                  // /admin/category -> new
$routes->get('admin/category/(:segment)', 'Admin::category/$1');    // /admin/category/{id}
$routes->get('admin/page', 'Admin::page');                        // /admin/page -> new
$routes->get('admin/page/(:segment)', 'Admin::page/$1');          // /admin/page/{id}
$routes->get('admin/user', 'Admin::user');                        // /admin/user -> new
$routes->get('admin/user/(:segment)', 'Admin::user/$1');          // /admin/user/{id}
$routes->get('admin/coupon', 'Admin::coupon');                    // /admin/coupon -> new
$routes->get('admin/coupon/(:segment)', 'Admin::coupon/$1');      // /admin/coupon/{id}
$routes->get('admin/(:any)', 'Admin::$1');
$routes->post('admin/(:any)', 'Admin::$1');

// PayPal routes
$routes->get('paypal/success', 'Paypal::success');
$routes->post('paypal/success', 'Paypal::success');
$routes->get('paypal/cancel', 'Paypal::cancel');
$routes->get('paypal/ipn', 'Paypal::ipn');
$routes->post('paypal/ipn', 'Paypal::ipn');
$routes->get('paypal/(:any)', 'Paypal::$1');
$routes->post('paypal/(:any)', 'Paypal::$1');

// Vendor/Category route (must be before the catch-all)
$routes->get('(:segment)-exam-dumps', 'Vendor::single/$1');

// Exam routes - specific exam questions
$routes->get('(:segment)/(:segment)-exam-questions', 'Exam::single/$1/$2');
// Also support shorter /vendor/slug form (e.g. /vmware/3v0-42.23)
$routes->get('(:segment)/(:segment)', 'Exam::single/$1/$2');

// API routes
$routes->get('rest_api/category/(:num)', 'RestApi::category/$1');
$routes->get('rest_api/category_all/(:any)/(:any)/(:any)/(:any)', 'RestApi::category_all/$1/$2/$3/$4');
$routes->get('rest_api/exam/(:num)', 'RestApi::exam/$1');
$routes->get('rest_api/exam_by_type/(:any)/(:any)/(:any)', 'RestApi::exam_by_type/$1/$2/$3');
$routes->get('rest_api/exam_by_name/(:any)', 'RestApi::exam_by_name/$1');

// Catch-all route for pages (must be last)
$routes->get('(:any)', 'See::page/$1');
