<?php

namespace App\Controllers;

class Account extends BaseController
{
    public function index()
    {
        if (! $this->session->get('user_id')) {
            return redirect()->to(base_url('account/signin'));
        }

        return redirect()->to(base_url('account/dashboard'));
    }

    public function dashboard()
    {
        if (! $this->session->get('user_id')) {
            return redirect()->to(base_url('account/signin'));
        }

        return $this->template('account/dashboard', [
            'title' => 'My Account',
            'class' => 'member-area dashboard',
        ]);
    }

    public function settings()
    {
        if (! $this->session->get('user_id')) {
            return redirect()->to(base_url('account/signin'));
        }

        return $this->template('account/settings', [
            'title' => 'Customer Profile',
            'class' => 'member-area profile',
        ]);
    }

    /**
     * Show sign-in form (GET). Form POSTs to Action::session('create') which checks email/password
     * via FunctionsModel::check_user() and redirects back here with ?login_error= on failure.
     */
    public function signin()
    {
        if ($this->session->get('user_id')) {
            return redirect()->to(base_url('account'));
        }

        $next = $this->request->getGet('next') ?? base_url('account');
        $loginError   = $this->request->getGet('login_error');
        $registerError = $this->request->getGet('register_error');
        $loginMessages = [
            'email'    => 'Please enter a valid email.',
            'password' => 'Please enter your password.',
            'invalid'  => 'Invalid Email/Password.',
        ];
        $registerMessages = [
            'recaptcha' => 'reCAPTCHA verification failed. Please try again.',
            'email'     => 'Please enter a valid email.',
            'name'      => 'Please enter your name.',
            'password'  => 'Password is required (min 4 characters).',
            'match'     => 'Passwords do not match.',
            'exists'    => 'A user with this email already exists.',
            'failed'    => 'Registration failed. Please try again.',
        ];
        $loginError   = isset($loginMessages[$loginError]) ? $loginMessages[$loginError] : null;
        $registerError = isset($registerMessages[$registerError]) ? $registerMessages[$registerError] : null;

        return $this->template('signin', [
            'title'         => 'Sign In',
            'class'         => 'signin frontend account',
            'next'          => $next,
            'loginError'    => $loginError,
            'registerError' => $registerError,
        ]);
    }

    public function register()
    {
        $next = $this->request->getGet('next') ?? base_url('account');
        $registerError = $this->request->getGet('register_error');
        $registerMessages = [
            'email'   => 'Please enter a valid email.',
            'name'    => 'Please enter your name.',
            'password' => 'Password is required (min 4 characters).',
            'match'   => 'Passwords do not match.',
            'exists'  => 'A user with this email already exists.',
            'failed'  => 'Registration failed. Please try again.',
        ];
        $registerError = isset($registerMessages[$registerError]) ? $registerMessages[$registerError] : null;

        return $this->template('register', [
            'title'         => 'Register',
            'class'         => 'register frontend account',
            'next'          => $next,
            'registerError' => $registerError,
        ]);
    }

    public function changepass()
    {
        if (! $this->session->get('user_id')) {
            return redirect()->to(base_url('account/signin'));
        }

        return $this->template('account/changepass', [
            'title' => 'Change Password',
            'class' => 'member-area changepass',
        ]);
    }

    public function orders()
    {
        if (! $this->session->get('user_id')) {
            return redirect()->to(base_url('account/signin'));
        }

        return $this->template('account/orders', [
            'title' => 'Orders',
            'class' => 'member-area orders',
        ]);
    }

    public function downloads()
    {
        if (! $this->session->get('user_id')) {
            return redirect()->to(base_url('account/signin'));
        }

        return $this->template('account/downloads', [
            'title' => 'Downloads',
            'class' => 'member-area downloads',
        ]);
    }

    public function order($id)
    {
        if (! $this->session->get('user_id')) {
            return redirect()->to(base_url('account/signin'));
        }

        $order = $this->Functions->orders('id', $id, 'single');
        if (! isset($order) || ! $order) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }

        if ($order->user !== (string) $this->session->get('user_id')) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }

        return $this->template('account/order', [
            'title' => 'View Order #' . $order->id,
            'class' => 'member-area order order-' . $order->id,
            'order' => $order,
        ]);
    }
}
