<?php

namespace App\Controllers;

use CodeIgniter\Controller;
use CodeIgniter\HTTP\RequestInterface;
use CodeIgniter\HTTP\ResponseInterface;
use Psr\Log\LoggerInterface;
use App\Models\FunctionsModel;

/**
 * BaseController provides a convenient place for loading components
 * and performing functions that are needed by all your controllers.
 */
abstract class BaseController extends Controller
{
    /**
     * Instance of the main Request object.
     *
     * @var RequestInterface
     */
    protected $request;

    /**
     * Instance of session.
     */
    protected $session;

    /**
     * Instance of Functions model.
     */
    protected $Functions;

    /**
     * Instance of cart (array-based for now).
     */
    protected $cart = [];

    /**
     * An array of helpers to be loaded automatically upon
     * class instantiation. These helpers will be available
     * to all other controllers that extend BaseController.
     *
     * @var list<string>
     */
    protected $helpers = ['url', 'form', 'text', 'html'];

    /**
     * @return void
     */
    public function initController(RequestInterface $request, ResponseInterface $response, LoggerInterface $logger)
    {
        // Do Not Edit This Line
        parent::initController($request, $response, $logger);

        // Preload any models, libraries, etc, here.
        $this->session = \Config\Services::session();
        $this->Functions = new FunctionsModel();
        
        // Cart stored in session
        $this->cart = $this->session->get('cart') ?? [];
    }

    /**
     * Load a view using the active theme
     */
    protected function template($view, $data = [])
    {
        $theme = $this->Functions->get_db_option('active-theme') ?? 'default';
        
        // Add common data
        $data['Functions'] = $this->Functions;
        $data['session'] = $this->session;
        $data['cart'] = $this->cart;
        
        // Router info for breadcrumbs etc. (CI4: controllerName returns FQCN, methodName returns method)
        $router = \Config\Services::router();
        $cn = $router->controllerName();
        $data['router_controller'] = $cn !== '' ? substr($cn, strrpos($cn, '\\') + 1) : '';
        $data['router_method'] = $router->methodName();
        
        return view($theme . '/' . $view, $data);
    }
}
