<?php

namespace App\Controllers;

class Exam extends BaseController
{
    public function single($cat = null, $exam = null)
    {
        if (!$cat || !$exam) {
            return $this->template('examnotfound', [
                'title' => 'No Exam Found!',
                'class' => '',
                'category' => null,
                'exam' => null
            ]);
        }
        
        $cat = urldecode($cat);
        $exam = urldecode($exam);
        
        $c = $this->Functions->category_front('slug', $cat);
        
        if (!$c) {
            return $this->template('examnotfound', [
                'title' => 'No Exam Found!',
                'class' => '',
                'category' => null,
                'exam' => null
            ]);
        }
        
        $e = null;
        
        if ($c->is_parent == 1) {
            $e = $this->Functions->Cats_by_parent_withexam($c->id, $exam);
        }
        
        if (!$e) {
            $e = $this->Functions->subCats_by_parent_withexam($c->id, $exam);
        }
        
        if (!$e) {
            return $this->template('examnotfound', [
                'title' => 'No Exam Found!',
                'class' => '',
                'category' => $c,
                'exam' => null
            ]);
        }
        
        return $this->template('exam', [
            'title' => $e->title . ' Exam Dumps ~ Tips to Pass ' . $e->title . ' Exam Questions',
            'class' => 'frontend exam exam-' . $e->id,
            'exam' => $e,
            'category' => $c
        ]);
    }
}
