<?php

namespace App\Controllers;

class Home extends BaseController
{
    public function index()
    {
        $data = [
            'title' => $this->Functions->get_db_option('site_name'),
            'class' => 'home frontend'
        ];
        
        return $this->template('home', $data);
    }

    public function testimonial()
    {
        return $this->template('testimonial');
    }

    /**
     * AJAX: Return exam listing section HTML (for lazy load on home page).
     */
    public function examListing()
    {
        $data = [
            'hotvendors' => $this->Functions->hotvendor(1),
            'Functions'   => $this->Functions,
        ];
        // Disable debug comments and toolbar so AJAX response is clean HTML only
        $html = view('default/exam_listing_ajax', $data, ['debug' => false]);
        return $this->response
            ->setBody($html)
            ->setHeader('Content-Type', 'text/html; charset=UTF-8');
    }
}
