<?php

namespace App\Controllers;

class Paypal extends BaseController
{
    /**
     * PayPal success return. Validate, add order, clear cart, redirect to thank-you.
     */
    public function success()
    {
        $post = $this->request->getPost();
        if (empty($post['custom']) || empty($post['item_number']) || empty($post['mc_gross'])) {
            $this->session->setFlashdata('msg', 'Invalid payment data.');
            $this->session->setFlashdata('msgClass', 'alert-danger');
            return redirect()->to(base_url('paypal/cancel'));
        }
        helper('cart');
        $cart       = $this->session->get('cart') ?? [];
        $cart       = is_array($cart) ? $cart : [];
        $grandTotal = cart_total($cart);
        $couponId   = $this->session->get('coupon');
        $charged    = $grandTotal;
        if ($couponId) {
            $coupon = $this->Functions->coupon('id', $couponId);
            if ($coupon && isset($coupon->discount)) {
                $charged = $grandTotal - (($coupon->discount / 100) * $grandTotal);
            }
        }
        $sku = $this->Functions->get_sku_cart();
        $uid = $this->session->get('user_id');
        $paymentGross = (float) $post['mc_gross'];
        if (number_format($charged, 2, '.', '') !== number_format($paymentGross, 2, '.', '')) {
            $this->session->setFlashdata('msg', 'Invalid charged amount.');
            $this->session->setFlashdata('msgClass', 'alert-danger');
            return redirect()->to(base_url('paypal/cancel'));
        }
        if ($sku !== $post['item_number']) {
            $this->session->setFlashdata('msg', 'Invalid paper selection.');
            $this->session->setFlashdata('msgClass', 'alert-danger');
            return redirect()->to(base_url('paypal/cancel'));
        }
        if ((string) $uid !== (string) $post['custom']) {
            $this->session->setFlashdata('msg', 'Invalid user.');
            $this->session->setFlashdata('msgClass', 'alert-danger');
            return redirect()->to(base_url('paypal/cancel'));
        }
        $couponObj    = $couponId ? $this->Functions->coupon('id', $couponId) : null;
        $couponString = ($couponObj && isset($couponObj->code)) ? $couponObj->code : '';
        $this->Functions->add_order($charged, $sku, (string) $uid, $couponString, date('Y-m-d H:i:s'));
        $this->session->remove('cart');
        $this->session->remove('coupon');
        return redirect()->to(base_url('thank-you'));
    }

    /**
     * PayPal cancel return.
     */
    public function cancel()
    {
        $this->session->setFlashdata('msg', 'PayPal payment was cancelled.');
        $this->session->setFlashdata('msgClass', 'alert-info');
        return redirect()->to(base_url('cart'));
    }

    /**
     * PayPal IPN (Instant Payment Notification). Stub for now.
     */
    public function ipn()
    {
        // Optional: verify IPN and log. No output.
        return $this->response->setStatusCode(200);
    }
}
