<?php

namespace App\Controllers;

class See extends BaseController
{
    public function cart()
    {
        return $this->template('dev_cart', [
            'title' => 'Cart',
            'class' => 'cart see frontend account'
        ]);
    }

    public function dev_cart()
    {
        return $this->template('dev_cart', [
            'title' => 'Cart',
            'class' => 'cart see frontend account'
        ]);
    }

    public function page($slug)
    {
        $page = $this->Functions->page('slug', $slug);
        
        if (!isset($page) || !$page) {
            throw \CodeIgniter\Exceptions\PageNotFoundException::forPageNotFound();
        }
        
        return $this->template('page', [
            'title' => $page->title,
            'class' => 'frontend page page-' . $page->id,
            'page' => $page
        ]);
    }

    public function thank_you()
    {
        return $this->template('thank-you', [
            'title' => 'Thank You',
            'class' => 'see frontend'
        ]);
    }

    public function termandcondition()
    {
        return $this->template('termandcondition', [
            'title' => 'Term and Condition',
            'class' => 'Term and Condition'
        ]);
    }

    public function return_policy()
    {
        return $this->template('returnpolicy', [
            'title' => 'Return Policy',
            'class' => 'Return Policy'
        ]);
    }

    public function admin_login()
    {
        $u = $this->session->get('user_id');
        
        if (isset($u) && $u) {
            $user = $this->Functions->user('id', $u);
            if ($user && $user->is_admin == '1') {
                return redirect()->to(base_url('admin'));
            } else {
                return redirect()->to(base_url());
            }
        }
        
        return view('admin/login', [
            'title' => 'Login to ' . $this->Functions->get_db_option('site_name')
        ]);
    }

    public function all()
    {
        return $this->template('all', [
            'title' => 'All Certifications',
            'class' => 'all see frontend'
        ]);
    }
}
