<?php

namespace App\Controllers;

use CodeIgniter\Exceptions\PageNotFoundException;

/**
 * Vendor/Category page: e.g. /aafm-exam-dumps shows the category (vendor) page with exams.
 */
class Vendor extends BaseController
{
    /**
     * Single vendor/category page by slug.
     * Route: (:segment)-exam-dumps -> Vendor::single/$1
     *
     * @param string $slug Category slug (e.g. "aafm" from "aafm-exam-dumps")
     */
    public function single($slug = null)
    {
        if (empty($slug)) {
            throw PageNotFoundException::forPageNotFound();
        }

        $slug = urldecode($slug);
        $category = $this->Functions->category('slug', $slug);

        if (! $category) {
            throw PageNotFoundException::forPageNotFound();
        }

        $subCats = [];
        if (isset($category->is_parent) && $category->is_parent == '1') {
            $subCats = $this->Functions->subCats_by_parent($category->id);
        }

        return $this->template('vendor', [
            'title'    => $category->name . ' Exam Dumps',
            'class'    => 'category frontend vendor',
            'category' => $category,
            'cats'     => $category,
            'subCats'  => $subCats,
        ]);
    }
}
