<?php

/**
 * Cart helper for CI4 migration.
 * Replaces CI3 Cart library format_number() and total_items().
 */

if (! function_exists('format_money')) {
    /**
     * Format number as money (2 decimals). Replaces $cart->format_number().
     */
    function format_money($num): string
    {
        return number_format((float) $num, 2);
    }
}

if (! function_exists('cart_total_items')) {
    /**
     * Return cart item count. Works with array or object.
     */
    function cart_total_items($cart): int
    {
        if (is_array($cart)) {
            return count($cart);
        }
        if (is_object($cart) && method_exists($cart, 'total_items')) {
            return (int) $cart->total_items();
        }
        return 0;
    }
}

if (! function_exists('cart_total')) {
    /**
     * Return cart grand total (sum of subtotals). Works with array or object.
     */
    function cart_total($cart): float
    {
        if (is_object($cart) && method_exists($cart, 'total')) {
            return (float) $cart->total();
        }
        if (! is_array($cart)) {
            return 0.0;
        }
        $total = 0.0;
        foreach ($cart as $item) {
            $sub = $item['subtotal'] ?? null;
            if ($sub !== null) {
                $total += (float) $sub;
            } else {
                $total += ((float) ($item['price'] ?? 0)) * ((int) ($item['qty'] ?? 1));
            }
        }
        return $total;
    }
}
