<?php
echo view('admin/includes/header');

// Server-side pagination (same pattern as admin/exams)
$page     = isset($_GET['page']) ? max(1, (int) $_GET['page']) : 1;
$perPage  = 25;
$offset   = ($page - 1) * $perPage;
$categories = $Functions->categories_paginated($perPage, $offset);
$total_count = $Functions->categories_total_count();
$start_count = $total_count > 0 ? $offset + 1 : 0;
$end_count   = min($offset + count($categories), $total_count);
$links       = isset($links) ? $links : '';
?>
<div id="page_content">
    <div id="page_content_inner">

        <div class="md-card">
            <div class="md-card-content">
                <div class="uk-grid" data-uk-grid-margin>
                    <div class="uk-width-1-1">
                        <div class="uk-overflow-container">
                            <div class="dt_colVis_buttons"></div>
                            <table class="uk-table" cellspacing="0" width="100%">
                                <thead>
                                    <tr>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Quantity</th>
                                        <th>Status</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
                                <tfoot>
                                    <tr>
                                        <th>Image</th>
                                        <th>Name</th>
                                        <th>Quantity</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                                <tbody>
                                    <?php
                                    if (isset($categories) && $categories):
                                        foreach ($categories as $cat):
                                            $count = count($Functions->advanced_exams(0, 'update', $cat->id));
                                            ?>
                                            <tr>
                                                <td>
                                                    <?php if ($cat->image): ?>
                                                        <img class="img_thumb" src="<?= base_url("uploads/{$cat->image}") ?>" alt="">
                                                    <?php endif; ?>
                                                </td>
                                                <td class="uk-text-large uk-text-nowrap">
                                                    <a href="<?= base_url("admin/category/{$cat->id}") ?>"><?= $cat->name ?></a>
                                                </td>
                                                <td><?= $count ?></td>
                                                <td>
                                                    <?php
                                                    if ($cat->status == '1') {
                                                        echo "Active";
                                                    } else {
                                                        echo "Deactive";
                                                    }
                                                    ?>
                                                </td>
                                                <td class="uk-text-nowrap">
                                                    <a href="<?= base_url("vendor/{$cat->slug}") ?>"><i class="material-icons md-24">&#xE8F4;</i></a>
                                                    <!--
                                                    --><a href="<?= base_url("action/delete_category/{csrf_hash()}/{$cat->id}") ?>" class="uk-margin-left"><i class="material-icons md-24">&#xE872;</i></a>
                                                </td>
                                            </tr>
                                            <?php
                                        endforeach;
                                    endif;
                                    ?>
                                </tbody>
                            </table>
                        </div>

                        <div class="dt-uikit-footer">
                            <div class="uk-grid">
                                <div class="uk-width-medium-3-10">
                                    <div aria-live="polite" class="dataTables_info" id="dt_tableExport_info" role="status">
                                        Showing <?= $start_count ?> to <?= $end_count ?> of <?= $total_count ?> entries
                                    </div>
                                </div>
                                <div class="uk-width-medium-7-10 uk-text-right">
                                    <?php
                                    $hasNext = $end_count < $total_count;
                                    $hasPrev = $page > 1;
                                    if ($hasPrev || $hasNext): ?>
                                        <ul class="uk-pagination">
                                            <?php if ($hasPrev): ?>
                                                <li><a href="?page=<?= $page - 1 ?>">&laquo; Prev</a></li>
                                            <?php endif; ?>
                                            <li class="uk-active"><span>Page <?= $page ?> of <?= max(1, (int) ceil($total_count / $perPage)) ?></span></li>
                                            <?php if ($hasNext): ?>
                                                <li><a href="?page=<?= $page + 1 ?>">Next &raquo;</a></li>
                                            <?php endif; ?>
                                        </ul>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- google web fonts -->
<script>
    WebFontConfig = {
        google: {
            families: [
                'Source+Code+Pro:400,700:latin',
                'Roboto:400,300,500,700,400italic:latin'
            ]
        }
    };
    (function () {
        var wf = document.createElement('script');
        wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
                '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
        wf.type = 'text/javascript';
        wf.async = 'true';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(wf, s);
    })();
</script>

<!-- common functions -->
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/common.min.js"></script>
<!-- uikit functions -->
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/uikit_custom.min.js"></script>
<!-- altair common functions/helpers -->
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/altair_admin_common.min.js"></script>
<!-- page specific plugins -->
<!-- datatables -->
<script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables/media/js/jquery.dataTables.min.js"></script>
<!-- datatables buttons-->
<script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables-buttons/js/dataTables.buttons.js"></script>
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/custom/datatables/buttons.uikit.js"></script>
<script src="<?php echo base_url('/'); ?>lib/admin/bower_components/jszip/dist/jszip.min.js"></script>
<script src="<?php echo base_url('/'); ?>lib/admin/bower_components/pdfmake/build/pdfmake.min.js"></script>
<script src="<?php echo base_url('/'); ?>lib/admin/bower_components/pdfmake/build/vfs_fonts.js"></script>
<script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables-buttons/js/buttons.colVis.js"></script>
<script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables-buttons/js/buttons.html5.js"></script>
<script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables-buttons/js/buttons.print.js"></script>

<!-- datatables custom integration -->
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/custom/datatables/datatables.uikit.min.js"></script>

<!--  datatables functions -->
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/pages/plugins_datatables.min.js"></script>
<script type="text/javascript">
    setInterval(function () {
        if (!$('div.dt-buttons .md-btn#addnew').length) {
            $('div.dt-buttons').append('<a class="md-btn" id="addnew" tabindex="0" href="category/new" title="Add New"><span><i class="material-icons">&#xE89C;</i> Add New</span></a>');
        }
    }, 500);
</script>

<?php echo view('admin/includes/footer') ?>