<?php
echo view('admin/includes/header');

// Simple server-side pagination for large exams table
$page    = isset($_GET['page']) ? max(1, (int) $_GET['page']) : 1;
$perPage = 200;
$offset  = ($page - 1) * $perPage;

// New signature: advanced_exams($limit, $order, $category, $offset)
$exams = $Functions->advanced_exams($perPage, 'update', false, $offset);
?>
<div id="page_content">
    <div id="page_content_inner">

        <div class="md-card">
            <div class="md-card-content">
                <div class="uk-grid" data-uk-grid-margin>
                    <div class="uk-width-1-1">
                        <div class="uk-overflow-container">
                            <div class="dt_colVis_buttons"></div>
                            <table id="dt_tableExport" class="uk-table" cellspacing="0" width="100%">
                                <thead>
                                <tr>
                                        <th>Name</th>
                                        <th>Title</th>
                                        <th>Slug</th>
                                        <th>Certification</th>
                                        <th>Price</th>
                                        <th>Action</th>
                                    </tr>
                                </thead>
        
                                <tfoot>
                                <tr>
                                        <th>Name</th>
                                        <th>Title</th>
                                        <th>Slug</th>
                                        <th>Certification</th>
                                        <th>Price</th>
                                        <th>Action</th>
                                    </tr>
                                </tfoot>
                                </thead>
                                <tbody>
                                    <?php
                                    if(isset($exams) && $exams):
                                    foreach ($exams as $exam):
                                        $cat = $Functions->category('id', $exam->category);
                                        // Safeguard: skip or degrade gracefully if category is missing
                                        $catSlug = ($cat && isset($cat->slug)) ? $cat->slug : null;
                                    ?>
                                    <tr>
                                        <td class="uk-text-large uk-text-nowrap">
                                            <a href="<?= base_url("admin/exam/{$exam->id}") ?>"><?= $exam->name ?></a>
                                        </td>
                                        <td class="uk-text-large uk-text-nowrap">
                                            <a href="<?= base_url("admin/exam/{$exam->id}") ?>"><?= $exam->title ?></a>
                                        </td>
                                        <td class="uk-text-large uk-text-nowrap">
                                            <?= $exam->slug ?>
                                        </td>
                                        <td class="uk-text-large uk-text-nowrap">
                                            <?= $exam->certification ?>
                                        </td>
                                        <td class="uk-text-large uk-text-nowrap">
                                            <?= '$'.format_money($exam->sale_price) ?>
                                        </td>
                                        <td class="uk-text-nowrap">
                                            <?php if ($catSlug): ?>
                                                <a href="<?= base_url("{$catSlug}/{$exam->slug}") ?>"><i class="material-icons md-24">&#xE8F4;</i></a>
                                            <?php else: ?>
                                                <span class="uk-text-muted" title="Category missing"><i class="material-icons md-24">&#xE8F4;</i></span>
                                            <?php endif; ?>
                                            <!--
                                                --><a href="<?= base_url("action/delete_exam/{csrf_hash()}/{$exam->id}") ?>" class="uk-margin-left"><i class="material-icons md-24">&#xE872;</i></a>
                                        </td>
                                    </tr>
                                    <?php
                                    endforeach;
                                    endif; ?>
                                </tbody>
                            </table>

                            <?php
                            // Very lightweight prev/next navigation (only shows when it makes sense)
                            $hasNext = (is_array($exams) && count($exams) === $perPage);
                            $hasPrev = $page > 1;
                            if ($hasPrev || $hasNext): ?>
                                <div class="uk-margin-top">
                                    <ul class="uk-pagination">
                                        <?php if ($hasPrev): ?>
                                            <li><a href="?page=<?= $page - 1 ?>">&laquo; Prev</a></li>
                                        <?php endif; ?>
                                        <li class="uk-active"><span>Page <?= $page ?></span></li>
                                        <?php if ($hasNext): ?>
                                            <li><a href="?page=<?= $page + 1 ?>">Next &raquo;</a></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
</div>

<!-- google web fonts -->
<script>
    WebFontConfig = {
        google: {
            families: [
                    'Source+Code+Pro:400,700:latin',
                    'Roboto:400,300,500,700,400italic:latin'
                ]
        }
    };
    (function() {
        var wf = document.createElement('script');
        wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
            '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
        wf.type = 'text/javascript';
        wf.async = 'true';
        var s = document.getElementsByTagName('script')[0];
        s.parentNode.insertBefore(wf, s);
    })();
</script>

<!-- common functions -->
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/common.min.js"></script>
<!-- uikit functions -->
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/uikit_custom.min.js"></script>
<!-- altair common functions/helpers -->
<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/altair_admin_common.min.js"></script>
<!-- page specific plugins -->
    <!-- datatables -->
    <script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables/media/js/jquery.dataTables.min.js"></script>
    <!-- datatables buttons-->
    <script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables-buttons/js/dataTables.buttons.js"></script>
    <script src="<?php echo base_url('/'); ?>lib/admin/assets/js/custom/datatables/buttons.uikit.js"></script>
    <script src="<?php echo base_url('/'); ?>lib/admin/bower_components/jszip/dist/jszip.min.js"></script>
    <script src="<?php echo base_url('/'); ?>lib/admin/bower_components/pdfmake/build/pdfmake.min.js"></script>
    <script src="<?php echo base_url('/'); ?>lib/admin/bower_components/pdfmake/build/vfs_fonts.js"></script>
    <script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables-buttons/js/buttons.colVis.js"></script>
    <script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables-buttons/js/buttons.html5.js"></script>
    <script src="<?php echo base_url('/'); ?>lib/admin/bower_components/datatables-buttons/js/buttons.print.js"></script>
    
    <!-- datatables custom integration -->
    <script src="<?php echo base_url('/'); ?>lib/admin/assets/js/custom/datatables/datatables.uikit.min.js"></script>

    <!--  datatables functions -->
    <script src="<?php echo base_url('/'); ?>lib/admin/assets/js/pages/plugins_datatables.js"></script>
    <script type="text/javascript">
        setInterval(function () {
            if(!$('div.dt-buttons .md-btn#addnew').length) {
                $('div.dt-buttons').append('<a class="md-btn" id="addnew" tabindex="0" href="exam/new" title="Add New"><span><i class="material-icons">&#xE89C;</i> Add New</span></a>');
            }
        }, 500);
    </script>

<?php echo view('admin/includes/footer') ?>