<?php echo view('admin/includes/header'); ?>

    <div id="page_content">
        <div id="page_heading" data-uk-sticky="{ top: 48, media: 960 }">
            <h1 id="product_edit_name">Send Mail</h1>
            <!--<span class="uk-text-muted uk-text-upper uk-text-small" id="product_edit_sn">SM-G925TZKFTMB</span>-->
        </div>
        <div id="page_content_inner">
            <?php
            // CI4-safe validation errors
            $errors = session('errors') ?? [];
            if (is_array($errors) && ! empty($errors)): ?>
                <div style="color: red;">
                    <?= implode('<br>', array_map('esc', $errors)); ?>
                </div>
            <?php endif; ?>
            <?php echo form_open('action/maildata', array('class'=>'uk-form-stacked', 'id'=>'form_to_submit'));
            ?>
                <div class="uk-grid uk-grid-medium" data-uk-grid-margin>
                    <div class="uk-width-xLarge-2-10 uk-width-large-3-10" style="width:94%;">
                        
                        <div class="md-card">
                            <div class="md-card-toolbar">
                                <h3 class="md-card-toolbar-heading-text">
                                    Send Email To All Users
                                </h3>
                            </div>
                            <div class="md-card-content">
                                
                                <div class="uk-form-row">
                                        <label for="product_edit_price_control">Subject</label>
                                        <?php echo form_input('title', set_value('title'), array('class'=>'md-input', 'id'=>'title')) ?>
                                </div>
                                <div class="uk-form-row">
                                        <label for="product_edit_price_control"><b>Message</b></label><br><br>
                                        <textarea id="desc" name="desc" rows="15" cols="132"></textarea>
                                </div>
                                
                            </div>
                        </div>
                    </div>
                    
                </div>
            </form>

        </div>
    </div>

    <div class="md-fab-wrapper">
        <a class="md-fab md-fab-primary" href="#" id="mail_submit" onclick="javascript: jQuery('#form_to_submit').submit(); return false;">
            <i class="material-icons">&#xE161;</i>
        </a>
    </div>

    <!-- google web fonts -->
    <script>
        WebFontConfig = {
            google: {
                families: [
                    'Source+Code+Pro:400,700:latin',
                    'Roboto:400,300,500,700,400italic:latin'
                ]
            }
        };
        (function() {
            var wf = document.createElement('script');
            wf.src = ('https:' == document.location.protocol ? 'https' : 'http') +
            '://ajax.googleapis.com/ajax/libs/webfont/1/webfont.js';
            wf.type = 'text/javascript';
            wf.async = 'true';
            var s = document.getElementsByTagName('script')[0];
            s.parentNode.insertBefore(wf, s);
        })();
    </script>

    <!-- common functions -->
    <script src="<?php echo base_url('/'); ?>lib/admin/assets/js/common.min.js"></script>
    <!-- uikit functions -->
    <script src="<?php echo base_url('/'); ?>lib/admin/assets/js/uikit_custom.min.js"></script>
    <!-- altair common functions/helpers -->
    <script src="<?php echo base_url('/'); ?>lib/admin/assets/js/altair_admin_common.min.js"></script>

    <!-- page specific plugins -->

    <!--  product edit functions -->
    <!--<script src="<?php echo base_url('/'); ?>lib/admin/assets/js/pages/ecommerce_product_edit.min.js"></script>-->
    <script src="<?php echo base_url('/'); ?>lib/admin/assets/js/pages/forms_advanced.min.js"></script>
    
    <script type="text/javascript">
        jQuery('input#product_edit_title_control').on('change', function(e){
            var value = jQuery(this).val();
            value = value.replace(/\s+/g, '-').toLowerCase();
            jQuery('input#slug').val(value);
        });
    </script>
    
<?php echo view('admin/includes/footer') ?>