<?php
echo $Functions->template("includes/header", get_defined_vars());
echo $Functions->template("includes/topbarNavigation", get_defined_vars());
$u = $Functions->user('id', $session->get('user_id'));
?>
<main class="account-page">
    <div class="container">
        <?php $Functions->template('account/top') ?>
        
        <div class="account-breadcrumb">
            <a href="<?= base_url('account/dashboard') ?>"><i class="fas fa-home"></i> Dashboard</a>
            <span class="separator">/</span>
            <span class="current">Change Password</span>
        </div>

        <div class="account-card" style="max-width: 600px; margin: 0 auto;">
            <div class="account-card-header">
                <h2 class="account-card-title">
                    <i class="fas fa-lock"></i> Change Password
                </h2>
            </div>
            <div class="account-card-body">
                <?php
                if(validation_errors()) {
                    echo '<div class="account-alert account-alert-danger">
                            <i class="fas fa-exclamation-circle"></i>
                            <div>
                                <strong>Validation Error</strong>
                                <p>'.validation_errors().'</p>
                            </div>
                          </div>';
                } 
                if($session->getFlashdata('msg')) {
                    $alertType = strpos($session->getFlashdata('msgClass'), 'success') !== false ? 'success' : 'danger';
                    echo '<div class="account-alert account-alert-'.$alertType.'">
                            <i class="fas fa-'.($alertType === 'success' ? 'check-circle' : 'exclamation-circle').'"></i>
                            <div>
                                <p>'.$session->getFlashdata('msg').'</p>
                            </div>
                          </div>';
                }
                echo form_open('action/changepass', ['class' => 'account-form']);
                ?>
                
                <div class="account-form-section">
                    <div class="account-form-group">
                        <label class="account-form-label">
                            <i class="fas fa-key"></i> Current Password
                        </label>
                        <?php echo form_password('oPassword', '', array('class'=>'account-form-control', 'placeholder'=>'Enter your current password')); ?>
                    </div>
                    
                    <div class="account-form-group">
                        <label class="account-form-label">
                            <i class="fas fa-lock"></i> New Password
                        </label>
                        <?php echo form_password('password', '', array('class'=>'account-form-control', 'placeholder'=>'Enter new password')); ?>
                        <small style="display: block; margin-top: 6px; color: var(--cl-text-muted); font-size: 0.875rem;">
                            <i class="fas fa-info-circle"></i> Password must be at least 4 characters long
                        </small>
                    </div>
                    
                    <div class="account-form-group">
                        <label class="account-form-label">
                            <i class="fas fa-lock"></i> Confirm New Password
                        </label>
                        <?php echo form_password('cPassword', '', array('class'=>'account-form-control', 'placeholder'=>'Re-enter new password')); ?>
                    </div>
                </div>

                <div class="account-form-actions">
                    <?php echo form_submit('', 'Update Password', array('class'=>'account-btn account-btn-primary')); ?>
                    <a href="<?= base_url('account/dashboard') ?>" class="account-btn account-btn-secondary">Cancel</a>
                </div>
                
                <?php echo form_close(); ?>
                
                <div style="margin-top: 24px; padding: 16px; background: var(--cl-bg-light); border-left: 4px solid var(--cl-primary); border-radius: 6px;">
                    <h4 style="margin: 0 0 8px 0; color: var(--cl-text); font-size: 0.95rem; font-weight: 600;">
                        <i class="fas fa-shield-alt"></i> Security Tips
                    </h4>
                    <ul style="margin: 0; padding-left: 20px; color: var(--cl-text-muted); font-size: 0.875rem; line-height: 1.6;">
                        <li>Use a strong password with a mix of letters, numbers, and symbols</li>
                        <li>Don't reuse passwords from other websites</li>
                        <li>Change your password regularly for better security</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</main>
<?php echo $Functions->template("includes/footer", get_defined_vars());
