<?php
echo $Functions->template("includes/header", get_defined_vars());
echo $Functions->template("includes/topbarNavigation", get_defined_vars());
$u = $Functions->user('id', $session->get('user_id'));
$orders = $Functions->orders('user', $u->id);
?>

<section class="account-section">
    <div class="container">
        <?php $Functions->template('account/top') ?>
        
        <div class="account-content">
            <!-- Dashboard Stats -->
            <div class="dashboard-stats">
                <div class="stat-card stat-card--primary">
                    <div class="stat-card-icon">
                        <i class="fa fa-shopping-cart"></i>
                    </div>
                    <div class="stat-card-content">
                        <div class="stat-card-value"><?php echo count($orders) ?></div>
                        <div class="stat-card-label">Total Orders</div>
                    </div>
                    <a href="<?php echo base_url('account/orders'); ?>" class="stat-card-link">
                        View Orders <i class="fa fa-arrow-right"></i>
                    </a>
                </div>

                <div class="stat-card stat-card--success">
                    <div class="stat-card-icon">
                        <i class="fa fa-download"></i>
                    </div>
                    <div class="stat-card-content">
                        <div class="stat-card-value">
                            <?php 
                            $downloads = $Functions->downloads('user', $u->id);
                            echo $downloads ? count($downloads) : 0;
                            ?>
                        </div>
                        <div class="stat-card-label">Downloads</div>
                    </div>
                    <a href="<?php echo base_url('account/downloads'); ?>" class="stat-card-link">
                        View History <i class="fa fa-arrow-right"></i>
                    </a>
                </div>

                <div class="stat-card stat-card--info">
                    <div class="stat-card-icon">
                        <i class="fa fa-history"></i>
                    </div>
                    <div class="stat-card-content">
                        <div class="stat-card-value"><?php echo count($orders) ?></div>
                        <div class="stat-card-label">Order History</div>
                    </div>
                    <a href="<?php echo base_url('account/orders'); ?>" class="stat-card-link">
                        View All <i class="fa fa-arrow-right"></i>
                    </a>
                </div>

                <div class="stat-card stat-card--warning">
                    <div class="stat-card-icon">
                        <i class="fa fa-refresh"></i>
                    </div>
                    <div class="stat-card-content">
                        <div class="stat-card-value">Quick</div>
                        <div class="stat-card-label">Re-Order</div>
                    </div>
                    <a href="<?php echo base_url('account/orders'); ?>" class="stat-card-link">
                        Browse <i class="fa fa-arrow-right"></i>
                    </a>
                </div>
            </div>

            <!-- Important Notice -->
            <div class="account-notice">
                <div class="account-notice-icon">
                    <i class="fa fa-info-circle"></i>
                </div>
                <div class="account-notice-content">
                    <strong>Important:</strong> You can download products from your orders when the status is "Complete". 
                    In some cases, it may take up to 24 hours to activate the order. If you experience any issues, 
                    please contact <a href="mailto:info@certsleads.com">info@certsleads.com</a> and we'll resolve it ASAP.
                </div>
            </div>

            <!-- Recent Orders -->
            <div class="account-card">
                <div class="account-card-header">
                    <h3 class="account-card-title">
                        <i class="fa fa-shopping-bag"></i> Recent Orders
                    </h3>
                    <a href="<?php echo base_url('account/orders'); ?>" class="account-card-link">
                        View All <i class="fa fa-arrow-right"></i>
                    </a>
                </div>
                <div class="account-card-body">
                    <?php if(isset($orders) && $orders): ?>
                    <div class="account-table-wrapper">
                        <table class="account-table">
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $recentOrders = array_slice($orders, 0, 5);
                                foreach($recentOrders as $c): ?>
                                <tr>
                                    <td>
                                        <span class="order-id">#<?php echo $c['id'] ?></span>
                                    </td>
                                    <td><?php echo date("M d, Y", strtotime($c['date'])); ?></td>
                                    <td>
                                        <span class="order-amount">$<?php echo format_money($c['charged']) ?></span>
                                    </td>
                                    <td>
                                        <div class="account-table-actions">
                                            <a href="<?= base_url("action/get_invoice/$u->id/{$c['id']}") ?>" class="account-btn account-btn--sm account-btn--outline">
                                                <i class="fa fa-file-text"></i> Invoice
                                            </a>
                                            <a href="<?= base_url("account/order/{$c['id']}") ?>" class="account-btn account-btn--sm account-btn--primary">
                                                <i class="fa fa-eye"></i> View Order
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="account-empty-state">
                        <div class="account-empty-icon">
                            <i class="fa fa-shopping-cart"></i>
                        </div>
                        <h4>No Orders Yet</h4>
                        <p>You haven't placed any orders. Start shopping to see your orders here.</p>
                        <a href="<?php echo base_url(); ?>" class="account-btn account-btn--primary">
                            <i class="fa fa-shopping-bag"></i> Start Shopping
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Recent Downloads -->
            <div class="account-card">
                <div class="account-card-header">
                    <h3 class="account-card-title">
                        <i class="fa fa-download"></i> Recent Downloads
                    </h3>
                    <a href="<?php echo base_url('account/downloads'); ?>" class="account-card-link">
                        View All <i class="fa fa-arrow-right"></i>
                    </a>
                </div>
                <div class="account-card-body">
                    <?php 
                    $downloads = $Functions->downloads('user', $u->id);
                    if(isset($downloads) && $downloads):?>
                    <div class="account-table-wrapper">
                        <table class="account-table">
                            <thead>
                                <tr>
                                    <th>Order</th>
                                    <th>Product</th>
                                    <th>Date</th>
                                    <th>IP Address</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php 
                            $recentDownloads = array_slice($downloads, 0, 5);
                            foreach($recentDownloads as $download): ?>
                                <tr>
                                    <td>
                                        <a href="<?= base_url("account/order/{$download->order}") ?>" class="order-link">
                                            #<?= $download->order ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php 
                                        $order = $Functions->orders('id', $download->order, 'single');
                                        $skuz = explode('|', $order->sku);
                                        foreach ($skuz as $key => $sku) {
                                            if($sku == '')
                                                continue;
                                            $productDetails = $Functions->exam('sku', $sku);
                                            if($productDetails->id == $download->product) {
                                                echo $productDetails->name;
                                            } else {
                                                continue;
                                            }
                                        }
                                        ?>
                                    </td>
                                    <td><?= date("M d, Y", strtotime($download->date)); ?></td>
                                    <td><code><?= $download->ip ?></code></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="account-empty-state">
                        <div class="account-empty-icon">
                            <i class="fa fa-download"></i>
                        </div>
                        <h4>No Downloads Yet</h4>
                        <p>You haven't downloaded any products yet.</p>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php echo $Functions->template("includes/footer", get_defined_vars());
