<?php
echo $Functions->template("includes/header", get_defined_vars());
echo $Functions->template("includes/topbarNavigation", get_defined_vars());
$u = $Functions->user('id', $session->get('user_id'));
?>

<section class="account-section">
    <div class="container">
        <?php $Functions->template('account/top') ?>
        
        <div class="account-content">
            <!-- Back to Dashboard -->
            <div class="account-breadcrumb">
                <a href="<?php echo base_url('account/dashboard') ?>" class="account-breadcrumb-link">
                    <i class="fa fa-arrow-left"></i> Back to Dashboard
                </a>
            </div>

            <!-- Download History Card -->
            <div class="account-card">
                <div class="account-card-header">
                    <h3 class="account-card-title">
                        <i class="fa fa-download"></i> Download History
                    </h3>
                </div>
                <div class="account-card-body">
                    <?php 
                    $downloads = $Functions->downloads('user', $u->id);
                    if(isset($downloads) && $downloads):?>
                    <div class="account-table-wrapper">
                        <table class="account-table">
                            <thead>
                                <tr>
                                    <th>Order</th>
                                    <th>Product</th>
                                    <th>Date</th>
                                    <th>IP Address</th>
                                </tr>
                            </thead>
                            <tbody>
                            <?php foreach($downloads as $download): ?>
                                <tr>
                                    <td>
                                        <a href="<?= base_url("account/order/{$download->order}") ?>" class="order-link">
                                            #<?= $download->order ?>
                                        </a>
                                    </td>
                                    <td>
                                        <?php 
                                        $order = $Functions->orders('id', $download->order, 'single');
                                        $skuz = explode('|', $order->sku);
                                        foreach ($skuz as $key => $sku) {
                                            if($sku == '')
                                                continue;
                                            $productDetails = $Functions->exam('id',$download->product);
                                            if($productDetails->id == $download->product) {
                                                echo $productDetails->name;
                                            } else {
                                                continue;
                                            }
                                        }
                                        ?>
                                    </td>
                                    <td><?= date("M d, Y h:i a", strtotime($download->date)); ?></td>
                                    <td><code><?= $download->ip ?></code></td>
                                </tr>
                            <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="account-empty-state">
                        <div class="account-empty-icon">
                            <i class="fa fa-download"></i>
                        </div>
                        <h4>No Downloads Yet</h4>
                        <p>You haven't downloaded any products yet. Once you download products, they will appear here.</p>
                        <a href="<?php echo base_url('account/orders'); ?>" class="account-btn account-btn--primary">
                            <i class="fa fa-shopping-bag"></i> View Orders
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php echo $Functions->template("includes/footer", get_defined_vars());
