<?php
echo $Functions->template("includes/header", get_defined_vars());
echo $Functions->template("includes/topbarNavigation", get_defined_vars());
$u = $Functions->user('id', $session->get('user_id'));
?>
<main class="account-page">
    <div class="container">
        <?php $Functions->template('account/top') ?>
        
        <div class="account-breadcrumb">
            <a href="<?= base_url('account/dashboard') ?>"><i class="fas fa-home"></i> Dashboard</a>
            <span class="separator">/</span>
            <a href="<?= base_url('account/orders') ?>">Orders</a>
            <span class="separator">/</span>
            <span class="current">Order #<?= $order->id ?></span>
        </div>

        <div class="account-card">
            <div class="account-card-header">
                <div style="display: flex; justify-content: space-between; align-items: center; flex-wrap: wrap; gap: 15px;">
                    <div>
                        <h2 class="account-card-title">
                            <i class="fas fa-receipt"></i> Order #<?= $order->id ?>
                        </h2>
                        <p style="margin: 8px 0 0 0; color: var(--cl-text-muted); font-size: 0.95rem;">
                            Placed on <?= date("F d, Y", strtotime($order->date)); ?>
                        </p>
                    </div>
                    <a href="<?= base_url('account/orders') ?>" class="account-btn account-btn-secondary">
                        <i class="fas fa-arrow-left"></i> Back to Orders
                    </a>
                </div>
            </div>
            <div class="account-card-body">
                <div class="account-table-wrapper">
                    <table class="account-table">
                        <thead>
                            <tr>
                                <th>Product</th>
                                <th>Price</th>
                                <th style="text-align: center;">Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $products = explode('|', $order->sku);
                            foreach($products as $product):
                                if($product == '')
                                    break;
                                $productDetails = $Functions->exam('sku', $product);?>
                            <tr>
                                <td>
                                    <div style="font-weight: 600; color: var(--cl-text);">
                                        <?php echo $productDetails->name; ?>
                                    </div>
                                </td>
                                <td>
                                    <span class="account-price">$<?php echo format_money($productDetails->sale_price); ?></span>
                                </td>
                                <td style="text-align: center;">
                                    <?php
                                    $slug = $productDetails->path_slug;
                                    if($Functions->check_update_period($order->id)):
                                    ?>
                                     <a href="<?= base_url("action/download/{$session->get('user_id')}/{$order->id}/{$productDetails->id}/{$slug}") ?>" 
                                        class="account-btn account-btn-primary account-btn-sm" 
                                        target="_blank">
                                        <i class="fas fa-download"></i> Download
                                     </a>
                                     <?php
                                     else:
                                     echo form_open('action/add_to_cart', ['style' => 'display: inline-block;']);
                                            echo form_hidden('product', $productDetails->id);
                                            echo form_hidden('sku', $productDetails->sku);
                                            echo form_submit('submit', 'Buy Again', array('class'=>'account-btn account-btn-secondary account-btn-sm'));
                                            echo form_close();
                                    endif; ?>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr class="account-table-total">
                                <td colspan="2"><strong>Total Amount</strong></td>
                                <td style="text-align: center;">
                                    <strong class="account-price" style="font-size: 1.1rem;">
                                        $<?= format_money($order->charged) ?>
                                    </strong>
                                </td>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>
<?php echo $Functions->template("includes/footer", get_defined_vars());
