<?php
echo $Functions->template("includes/header", get_defined_vars());
echo $Functions->template("includes/topbarNavigation", get_defined_vars());
$u = $Functions->user('id', $session->get('user_id'));
$orders = $Functions->orders('user', $u->id);
?>

<section class="account-section">
    <div class="container">
        <?php $Functions->template('account/top') ?>
        
        <div class="account-content">
            <!-- Back to Dashboard -->
            <div class="account-breadcrumb">
                <a href="<?php echo base_url('account/dashboard') ?>" class="account-breadcrumb-link">
                    <i class="fa fa-arrow-left"></i> Back to Dashboard
                </a>
            </div>

            <!-- Orders Card -->
            <div class="account-card">
                <div class="account-card-header">
                    <h3 class="account-card-title">
                        <i class="fa fa-shopping-bag"></i> All Orders
                    </h3>
                    <span class="account-badge"><?php echo count($orders) ?> Orders</span>
                </div>
                <div class="account-card-body">
                    <?php if(isset($orders) && $orders): ?>
                    <div class="account-table-wrapper">
                        <table class="account-table">
                            <thead>
                                <tr>
                                    <th>Order ID</th>
                                    <th>Date</th>
                                    <th>Amount</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($orders as $c): ?>
                                <tr>
                                    <td>
                                        <span class="order-id">#<?php echo $c['id'] ?></span>
                                    </td>
                                    <td><?php echo date("M d, Y", strtotime($c['date'])); ?></td>
                                    <td>
                                        <span class="order-amount">$<?php echo format_money($c['charged']) ?></span>
                                    </td>
                                    <td>
                                        <div class="account-table-actions">
                                            <a href="<?= base_url("action/get_invoice/$u->id/{$c['id']}") ?>" class="account-btn account-btn--sm account-btn--outline">
                                                <i class="fa fa-file-text"></i> Invoice
                                            </a>
                                            <a href="<?= base_url("account/order/{$c['id']}") ?>" class="account-btn account-btn--sm account-btn--primary">
                                                <i class="fa fa-eye"></i> View Order
                                            </a>
                                        </div>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                    <?php else: ?>
                    <div class="account-empty-state">
                        <div class="account-empty-icon">
                            <i class="fa fa-shopping-cart"></i>
                        </div>
                        <h4>No Orders Yet</h4>
                        <p>You haven't placed any orders. Start shopping to see your orders here.</p>
                        <a href="<?php echo base_url(); ?>" class="account-btn account-btn--primary">
                            <i class="fa fa-shopping-bag"></i> Start Shopping
                        </a>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<?php echo $Functions->template("includes/footer", get_defined_vars());
