<?php
echo $Functions->template("includes/header", get_defined_vars());
echo $Functions->template("includes/topbarNavigation", get_defined_vars());
$u = $Functions->user('id', $session->get('user_id'));
?>
<main class="account-page">
    <div class="container">
        <?php $Functions->template('account/top') ?>
        
        <div class="account-breadcrumb">
            <a href="<?= base_url('account/dashboard') ?>"><i class="fas fa-home"></i> Dashboard</a>
            <span class="separator">/</span>
            <span class="current">Profile Settings</span>
        </div>

        <div class="account-card">
            <div class="account-card-header">
                <h2 class="account-card-title">
                    <i class="fas fa-user-cog"></i> Profile Settings
                </h2>
            </div>
            <div class="account-card-body">
                <?php
                if(validation_errors()) {
                    echo '<div class="account-alert account-alert-danger">
                            <i class="fas fa-exclamation-circle"></i>
                            <div>
                                <strong>Validation Error</strong>
                                <p>'.validation_errors().'</p>
                            </div>
                          </div>';
                } 
                if($session->getFlashdata('msg')) {
                    $alertType = strpos($session->getFlashdata('msgClass'), 'success') !== false ? 'success' : 'danger';
                    echo '<div class="account-alert account-alert-'.$alertType.'">
                            <i class="fas fa-'.($alertType === 'success' ? 'check-circle' : 'exclamation-circle').'"></i>
                            <div>
                                <p>'.$session->getFlashdata('msg').'</p>
                            </div>
                          </div>';
                }
                echo form_open('action/update_profile', ['class' => 'account-form']);
                ?>
                
                <div class="account-form-section">
                    <h3 class="account-form-section-title">Personal Information</h3>
                    <div class="account-form-row">
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-user"></i> Full Name
                            </label>
                            <?php echo form_input('name', set_value('name', $u->name), array('class'=>'account-form-control', 'placeholder'=>'Enter your full name')); ?>
                        </div>
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-envelope"></i> Email Address
                            </label>
                            <?php echo form_input('email', set_value('email', $u->email), array('class'=>'account-form-control', 'placeholder'=>'Enter your email')); ?>
                        </div>
                    </div>
                    <div class="account-form-row">
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-venus-mars"></i> Gender
                            </label>
                            <?php echo form_dropdown('gender', array('male'=>'Male', 'female'=>'Female'), $u->gender, array('class'=>'account-form-control')); ?>
                        </div>
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-phone"></i> Phone
                            </label>
                            <?php echo form_input('phone', set_value('phone', $u->phone), array('class'=>'account-form-control', 'placeholder'=>'Enter phone number')); ?>
                        </div>
                    </div>
                    <div class="account-form-row">
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-mobile-alt"></i> Mobile
                            </label>
                            <?php echo form_input('mobile', set_value('mobile', $u->mobile), array('class'=>'account-form-control', 'placeholder'=>'Enter mobile number')); ?>
                        </div>
                        <div class="account-form-group"></div>
                    </div>
                </div>

                <div class="account-form-section">
                    <h3 class="account-form-section-title">Address Information</h3>
                    <div class="account-form-group">
                        <label class="account-form-label">
                            <i class="fas fa-map-marker-alt"></i> Street Address
                        </label>
                        <?php echo form_input('address', set_value('address', $u->address), array('class'=>'account-form-control', 'placeholder'=>'Enter street address')); ?>
                    </div>
                    <div class="account-form-row">
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-city"></i> City
                            </label>
                            <?php echo form_input('city', set_value('city', $u->city), array('class'=>'account-form-control', 'placeholder'=>'Enter city')); ?>
                        </div>
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-map"></i> State
                            </label>
                            <?php echo form_input('state', set_value('state', $u->state), array('class'=>'account-form-control', 'placeholder'=>'Enter state')); ?>
                        </div>
                    </div>
                    <div class="account-form-row">
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-globe"></i> Country
                            </label>
                            <?php echo form_dropdown('country', $Functions->country_list(), $u->country, array('class'=>'account-form-control')); ?>
                        </div>
                        <div class="account-form-group">
                            <label class="account-form-label">
                                <i class="fas fa-mail-bulk"></i> Zip Code
                            </label>
                            <?php echo form_input('zip', set_value('zip', $u->zip), array('class'=>'account-form-control', 'placeholder'=>'Enter zip code')); ?>
                        </div>
                    </div>
                </div>

                <div class="account-form-section">
                    <h3 class="account-form-section-title">Business Information</h3>
                    <div class="account-form-group">
                        <label class="account-form-label">
                            <i class="fas fa-file-invoice"></i> VAT Number
                        </label>
                        <?php echo form_input('vat', set_value('vat', $u->vat), array('class'=>'account-form-control', 'placeholder'=>'Enter VAT number (optional)')); ?>
                    </div>
                </div>

                <div class="account-form-actions">
                    <?php echo form_submit('', 'Save Changes', array('class'=>'account-btn account-btn-primary')); ?>
                    <a href="<?= base_url('account/dashboard') ?>" class="account-btn account-btn-secondary">Cancel</a>
                </div>
                
                <?php echo form_close(); ?>
            </div>
        </div>
    </div>
</main>
<?php echo $Functions->template("includes/footer", get_defined_vars());
