<?php
echo view('default/includes/header', get_defined_vars());
echo view('default/includes/topbarNavigation', get_defined_vars());

$allcategories = $Functions->categoriesfront('parent', 0, false);
?>
<main class="all-vendors-page">
    <div class="container">
        <section class="section-hero section-hero--center">
            <h1 class="page-title">All Certification Vendors</h1>
            <p class="page-lead">Browse exam dumps by vendor. Select a certification provider below to view available exams and study materials.</p>
        </section>

        <?php if (!empty($allcategories)) { ?>
        <section class="all-vendors-grid-wrap">
            <div class="all-vendors-grid">
                <?php foreach ($allcategories as $cat) {
                    $slug = isset($cat->slug) ? $cat->slug : '';
                    $name = isset($cat->name) ? $cat->name : '';
                    $href = base_url($slug . '-exam-dumps');
                    $imgSrc = '';
                    if (!empty($cat->image)) {
                        $imgSrc = (strpos($cat->image, 'http') === 0 || strpos($cat->image, '//') === 0) ? $cat->image : base_url($cat->image);
                    } else {
                        $imgSrc = base_url('uploads/vendor/' . $slug . '.jpg');
                    }
                ?>
                <a href="<?= esc($href) ?>" class="all-vendor-card">
                    <span class="all-vendor-card-img-wrap">
                        <img src="<?= esc($imgSrc) ?>" alt="<?= esc($name) ?> exam dumps" class="all-vendor-card-img" loading="lazy" onerror="this.style.visibility='hidden'; this.nextElementSibling.style.display='flex';">
                        <span class="all-vendor-card-placeholder" style="display:none;" aria-hidden="true"><?= esc(mb_substr($name, 0, 1)) ?></span>
                    </span>
                    <span class="all-vendor-card-name"><?= esc($name) ?></span>
                </a>
                <?php } ?>
            </div>
        </section>
        <?php } else { ?>
        <p class="all-vendors-empty">No vendors available at the moment.</p>
        <?php } ?>
    </div>
    </main>
<?php
echo view('default/includes/footer', get_defined_vars());
?>
