<?php
echo view('default/includes/header', get_defined_vars());
echo view('default/includes/topbarNavigation', get_defined_vars());
$ziina_active = $Functions->get_db_option('ziina_active');
$paypal_active = $Functions->get_db_option('paypal_status');
$stripe_active = $Functions->get_db_option('stripe_active');
// Load Stripe keys dynamically
$stripe_sandbox = $Functions->get_db_option('stripe_sandbox');
if ($stripe_sandbox == 'true') {
    // Use sandbox/test keys
    $stripe_publishable_key = $Functions->get_db_option('stripe_sandbox_publishable_key');
} else {
    // Use live keys
    $stripe_publishable_key = $Functions->get_db_option('stripe_live_publishable_key');
}
//Retrieve total items inside cart
$count = cart_total_items($cart);

// Cart is already an array of items (session-based)
if (!is_array($cart)) {
    $cart = [];
}

//Check of user is already logged in
$userEmail = '';
if ($session->get('user_id')) {
    $userID = $Functions->user('id', $session->get('user_id'));
    $userEmail = $userID->email;
}
?>
<main class="cart-page">
    <div class="container">
        <div class="cart-header">
            <h1 class="cart-title">
                <i class="fas fa-shopping-cart"></i> Shopping Cart
            </h1>
            <p class="cart-subtitle"><?= $count ?> item<?= $count != 1 ? 's' : '' ?> in your cart</p>
        </div>

    <?php if ($count >= 1) { ?>
        <div class="cart-content">
            <div class="cart-items-section">
                <?php
                $flashMsg = $session->getFlashdata('msg');
                $flashClass = $session->getFlashdata('msgClass') ?: 'alert-info';
                if ($flashMsg !== null && $flashMsg !== '') {
                    $alertType = strpos($flashClass, 'success') !== false ? 'success' : (strpos($flashClass, 'danger') !== false ? 'danger' : 'info');
                    echo '<div class="cart-alert cart-alert-' . $alertType . '">
                            <i class="fas fa-' . ($alertType === 'success' ? 'check-circle' : ($alertType === 'danger' ? 'exclamation-circle' : 'info-circle')) . '"></i>
                            <span>' . esc($flashMsg) . '</span>
                          </div>';
                }
                ?>
                
                <div class="cart-card">
                    <div class="cart-card-header">
                        <h2 class="cart-card-title">
                            <i class="fas fa-box"></i> Cart Items
                        </h2>
                        <a href="<?php echo base_url('action/destroy_cart') ?>" class="cart-btn cart-btn-danger cart-btn-sm">
                            <i class="fas fa-trash"></i> Empty Cart
                        </a>
                    </div>
                    <div class="cart-card-body">
                        <?php echo form_open('action/update_cart', ['id' => 'cart-update-form']); ?>
                        <div class="cart-items-list">
                            <?php $i = 1; ?>
                            <?php foreach (is_array($cart) ? $cart : [] as $items):
                                $rowid = $items['rowid'] ?? $items['id'] ?? $items['sku'] ?? '';
                                $subtotal = $items['subtotal'] ?? (($items['price'] ?? 0) * ($items['qty'] ?? 1));
                            ?>
                                <?php echo form_hidden($i . '[rowid]', $rowid); ?>
                                <div class="cart-item">
                                    <div class="cart-item-details">
                                        <div class="cart-item-name">
                                            <i class="fas fa-certificate" style="color: var(--cl-primary); margin-right: 8px;"></i>
                                            <?php echo $items['name'] ?? ''; ?>
                                        </div>
                                        <div class="cart-item-price">
                                            <span class="cart-item-label">Price:</span>
                                            <span class="cart-item-value">$<?php echo format_money($items['price'] ?? 0); ?></span>
                                        </div>
                                    </div>
                                    <div class="cart-item-actions">
                                        <div class="cart-item-subtotal">
                                            <span class="cart-item-label">Subtotal:</span>
                                            <span class="cart-item-value">$<?php echo format_money($subtotal); ?></span>
                                        </div>
                                        <a href="<?php echo base_url("action/remove_from_cart/{$rowid}"); ?>" 
                                           class="cart-item-remove" 
                                           title="Remove item">
                                            <i class="fas fa-trash-alt"></i>
                                        </a>
                                    </div>
                                </div>
                                <?php $i++; ?>
                            <?php endforeach; ?>
                        </div>
                        
                        <div class="cart-actions-row">
                            <button type="submit" class="cart-btn cart-btn-secondary">
                                <i class="fas fa-sync-alt"></i> Update Cart
                            </button>
                        </div>
                        <?php echo form_close(); ?>
                    </div>
                </div>
            </div>
            
            <div class="cart-summary-section">
                <div class="cart-card">
                    <div class="cart-card-header">
                        <h2 class="cart-card-title">
                            <i class="fas fa-receipt"></i> Order Summary
                        </h2>
                    </div>
                    <div class="cart-card-body">
                        <?php if (!$session->get('coupon')): ?>
                            <div class="cart-promo-section">
                                <label class="cart-promo-label">
                                    <i class="fas fa-tag"></i> Promotional Code
                                </label>
                                <div class="cart-promo-input-group">
                                    <input type="text" 
                                           name="coupon" 
                                           id="coupon" 
                                           class="cart-promo-input" 
                                           placeholder="e.g. CL40" />
                                    <button type="button" 
                                            id="apply-coupon-btn" 
                                            class="cart-btn cart-btn-primary cart-btn-sm">
                                        Apply
                                    </button>
                                </div>
                            </div>
                        <?php else:
                            $coupon = $Functions->coupon('id', $session->get('coupon'));
                        ?>
                            <div class="cart-promo-applied">
                                <i class="fas fa-check-circle"></i>
                                <div>
                                    <strong>Promo Code Applied</strong>
                                    <p><?php echo strtoupper($coupon->code) ?> 
                                        <a href="<?php echo base_url('action/remove_coupon') ?>" class="cart-promo-remove">
                                            <i class="fas fa-times"></i> Remove
                                        </a>
                                    </p>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <div class="cart-summary-divider"></div>
                        
                        <div class="cart-summary-total">
                            <span class="cart-summary-label">Total Amount:</span>
                            <div class="cart-summary-amount">
                                <?php
                                $grandTotal = cart_total($cart);
                                if (!$session->get('coupon')) {
                                    echo '<span class="cart-total-price">$' . format_money($grandTotal) . '</span>';
                                } else {
                                    $discount = isset($coupon->discount) ? (float) $coupon->discount : 0;
                                    $afterDiscount = $grandTotal - (($discount / 100) * $grandTotal);
                                    echo '<div class="cart-discount-pricing">
                                            <span class="cart-original-price">$' . format_money($grandTotal) . '</span>
                                            <span class="cart-discounted-price">$' . format_money($afterDiscount) . '</span>
                                            <span class="cart-discount-badge">' . $discount . '% OFF</span>
                                          </div>';
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
                
                
            </div>
        </div>
        <div class="cart-card">
                    <div class="cart-card-header">
                        <h2 class="cart-card-title">
                            <i class="fas fa-credit-card"></i> Checkout
                        </h2>
                    </div>
                    <div class="cart-card-body">
                        <?php echo form_open('', ['id' => 'checkoutForm']); ?>
                        
                        <?php if (empty($userEmail)) { ?>
                            <div class="cart-form-group">
                                <label class="cart-form-label">
                                    <i class="fas fa-envelope"></i> Email Address <span class="cart-required">*</span>
                                </label>
                                <input type="email" 
                                       name="email" 
                                       class="cart-form-control" 
                                       placeholder="Enter your email" 
                                       required />
                            </div>
                        <?php } else { ?>
                            <div class="cart-user-info">
                                <i class="fas fa-user-check"></i>
                                <div>
                                    <strong>Logged in as</strong>
                                    <p><?= $userEmail ?></p>
                                </div>
                            </div>
                            <input type="hidden" value="<?= $userEmail ?>" name="email" />
                        <?php } ?>
                        
                        <?php if ($stripe_active == "true") { ?>
                            <div class="cart-form-group" id="stripe-card-section" style="display: none;">
                                <label class="cart-form-label">
                                    <i class="fas fa-credit-card"></i> Card Details
                                </label>
                                <div id="card-element" class="cart-stripe-element"></div>
                                <div id="card-errors" class="cart-stripe-errors"></div>
                            </div>
                        <?php } ?>
                        
                        <div class="cart-payment-methods">
                            <?php if ($stripe_active == "true") { ?>
                                <button type="button" 
                                        class="cart-payment-btn" 
                                        id="stripe-payment-btn">
                                    <div class="cart-payment-icon">
                                        <i class="fab fa-cc-stripe"></i>
                                    </div>
                                    <div class="cart-payment-info">
                                        <span class="cart-payment-name">Stripe</span>
                                        <small class="cart-payment-desc">Secure Card Payment</small>
                                    </div>
                                    <i class="fas fa-chevron-right cart-payment-arrow"></i>
                                </button>
                            <?php } ?>
                            
                            <?php if ($ziina_active == "true") { ?>
                                <button type="button" 
                                        class="cart-payment-btn" 
                                        onclick="submitCheckout('<?= site_url('action/usercheckout') ?>')">
                                    <div class="cart-payment-icon">
                                        <i class="fas fa-shopping-bag"></i>
                                    </div>
                                    <div class="cart-payment-info">
                                        <span class="cart-payment-name">Standard Checkout</span>
                                        <small class="cart-payment-desc">Quick & Easy</small>
                                    </div>
                                    <i class="fas fa-chevron-right cart-payment-arrow"></i>
                                </button>
                            <?php } ?>
                            
                            <?php if ($paypal_active == "true") { ?>
                                <button type="button" 
                                        class="cart-payment-btn" 
                                        onclick="submitCheckout('<?= site_url('action/paypal_standard_checkout') ?>')">
                                    <div class="cart-payment-icon">
                                        <i class="fab fa-paypal"></i>
                                    </div>
                                    <div class="cart-payment-info">
                                        <span class="cart-payment-name">PayPal</span>
                                        <small class="cart-payment-desc">Fast & Secure</small>
                                    </div>
                                    <i class="fas fa-chevron-right cart-payment-arrow"></i>
                                </button>
                            <?php } ?>
                        </div>
                        
                        <?php echo form_close(); ?>
                    </div>
                </div>
    <?php } else { ?>
        <div class="cart-empty">
            <div class="cart-empty-icon">
                <i class="fas fa-shopping-cart"></i>
            </div>
            <h2 class="cart-empty-title">Your cart is empty</h2>
            <p class="cart-empty-text">Looks like you haven't added any items to your cart yet.</p>
            <a href="<?= base_url() ?>" class="cart-btn cart-btn-primary">
                <i class="fas fa-arrow-left"></i> Continue Shopping
            </a>
        </div>
    <?php } ?>
    </div>
</main>

<!-- Stripe.js -->
<script src="https://js.stripe.com/v3/"></script>

<script>
function submitCheckout(actionUrl) {
    const form = document.getElementById('checkoutForm');
    form.action = actionUrl;
    form.requestSubmit();   
}
// Stripe integration
<?php if ($stripe_active == "true") { ?>
try {
var stripe = Stripe('<?php echo $stripe_publishable_key; ?>');
var elements = stripe.elements();

var style = {
    base: {
        fontSize: '16px',
        color: '#424770',
        '::placeholder': {
            color: '#aab7c4',
        },
    },
    invalid: {
        color: '#9e2146',
    },
};

var card = elements.create('card', {style: style});

var cardElement = document.getElementById('card-element');
if (cardElement) {
    card.mount('#card-element');
}

card.addEventListener('change', function(event) {
    var displayError = document.getElementById('card-errors');
    if (displayError) {
        if (event.error) {
            displayError.textContent = event.error.message;
        } else {
            displayError.textContent = '';
        }
    }
});

var stripeBtn = document.getElementById('stripe-payment-btn');
if (stripeBtn) {
stripeBtn.addEventListener('click', function(event) {
    event.preventDefault();
    
    var cardSection = document.getElementById('stripe-card-section');
    var button = document.getElementById('stripe-payment-btn');
    
    if (cardSection.style.display === 'none') {
        cardSection.style.display = 'block';
        button.innerHTML = '<div class="cart-payment-icon"><i class="fab fa-cc-stripe"></i></div><div class="cart-payment-info"><span class="cart-payment-name">Complete Payment</span><small class="cart-payment-desc">Enter card details above</small></div><i class="fas fa-chevron-right cart-payment-arrow"></i>';
        return;
    }
    
    var emailInput = document.querySelector('input[name="email"]');
    if (!emailInput || !emailInput.value.trim()) {
        alert('Please provide your email address.');
        return;
    }
    
    button.disabled = true;
    button.innerHTML = '<div class="cart-payment-icon"><i class="fas fa-spinner fa-spin"></i></div><div class="cart-payment-info"><span class="cart-payment-name">Processing...</span><small class="cart-payment-desc">Please wait</small></div>';
    
    stripe.createToken(card).then(function(result) {
        if (result.error) {
            var errorElement = document.getElementById('card-errors');
            errorElement.textContent = result.error.message;
            
            button.disabled = false;
            button.innerHTML = '<div class="cart-payment-icon"><i class="fab fa-cc-stripe"></i></div><div class="cart-payment-info"><span class="cart-payment-name">Complete Payment</span><small class="cart-payment-desc">Enter card details above</small></div><i class="fas fa-chevron-right cart-payment-arrow"></i>';
        } else {
            stripeTokenHandler(result.token);
        }
    });
});
}

function stripeTokenHandler(token) {
    var form = document.getElementById('checkoutForm');
    var hiddenInput = document.createElement('input');
    hiddenInput.setAttribute('type', 'hidden');
    hiddenInput.setAttribute('name', 'stripeToken');
    hiddenInput.setAttribute('value', token.id);
    form.appendChild(hiddenInput);
    
    form.action = '<?= base_url('action/stripeSubmit') ?>';
    form.submit();
}

setTimeout(function() {
    $('.auto-dismiss').fadeOut('slow');
}, 5000);

} catch (e) {
    console.error('Stripe initialization error:', e);
}
<?php } ?>
</script>

<?php if ($count >= 1) { ?>
    <script>
        $("#button").click(function () {
            $('html, body').animate({
                scrollTop: $("#sec").offset().top
            }, 800);
        });
    </script>
    
    <script type="text/javascript">
  $(document).ready(function() {
      <?php
      $alreadyAttempted = (bool) $session->get('promo_auto_attempted');
      $hasCoupon = (bool) $session->get('coupon');
      if (!$hasCoupon && !$alreadyAttempted):
          $session->set('promo_auto_attempted', true);
      ?>
      if ($('#coupon').length && $('#cart-update-form').length) {
          $('#coupon').val("CL40");
          $('#cart-update-form').submit();
      }
      <?php endif; ?>

      $('#apply-coupon-btn').on('click', function() {
          var code = ($('#coupon').val() || '').trim();
          if (!code) {
              alert('Please enter a promotional code.');
              return;
          }
          var btn = $(this);
          btn.prop('disabled', true).text('Applying…');
          var fd = new FormData();
          fd.append('coupon', code);
          var tokenName = '<?= csrf_token() ?>';
          var tokenVal = '<?= csrf_hash() ?>';
          if (tokenName && tokenVal) {
              fd.append(tokenName, tokenVal);
          }
          fetch('<?= site_url("action/update_cart") ?>', {
              method: 'POST',
              body: fd,
              redirect: 'follow'
          }).then(function() {
              window.location.href = '<?= site_url("cart") ?>';
          }).catch(function() {
              btn.prop('disabled', false).text('Apply');
              alert('Could not apply code. Please try again.');
          });
      });
  });
  </script>
<?php } ?>
<?php
echo view('default/includes/footer', get_defined_vars());
