<title><?= esc($title) ?></title>
<?php
$today = date("Y-m-d");
$days_ago = date('Y-m-d', strtotime('-2 days', strtotime($today)));
$input = array("4.8", "4.7", "4.6");
$rand_val = array_rand($input, 1);
$reviewsNumber = array("1121", "551", "173", "222", "518", "95");
$rand_review = array_rand($reviewsNumber, 1);
?>
<script type="application/ld+json">
{"@context":"http://schema.org","@type":"Product","aggregateRating":{"@type":"AggregateRating","ratingValue":"<?php $session->set('rating_val', $input[$rand_val]); echo $input[$rand_val]; ?>","reviewCount":"<?= $reviewsNumber[$rand_review] ?>"},"image":"https://www.Certsleads.com/uploads/p231.png","name":"<?= esc($exam->title) ?> Exam","sku":"<?= esc($exam->title) ?>","description":"Bundle Pack Offer","releaseDate":"<?= date("F d, Y", strtotime($exam->update)) ?>","offers":{"@type":"Offer","availability":"http://schema.org/InStock","price":"59.00","priceCurrency":"USD"},"review":[{"@type":"Review","author":"Lucas","datePublished":"<?= date("F d, Y", strtotime($exam->update)) ?>","description":"Absolutely Valid Dumps","reviewRating":{"@type":"Rating","bestRating":"4.8","ratingValue":"5","worstRating":"0"}}]}
</script>
<?php
echo view('default/includes/header', get_defined_vars());
echo view('default/includes/topbarNavigation', get_defined_vars());
$topCategories = $Functions->categories('all', 5);
$cats = $Functions->categories_front_all('all', 0);
$topvendors = $Functions->topvendor();
$hotvendors = $Functions->hotvendor(1);
$cat = $Functions->category('id', $exam->category);
$parent_argument = 0;
if ($cat && is_object($cat) && $cat->is_parent == 0) {
    $parent_argument = $cat->its_parent;
} elseif ($cat && is_object($cat) && $cat->is_parent == 1) {
    $parent_argument = $cat->id;
}
$parent_cat = $Functions->parentcategory($parent_argument);
$already_bought = $Functions->is_already_bought($exam->id);
if ($already_bought) {
    $order = $already_bought;
}
$exam_title = $exam->title;
$exam_name = $exam->name ?? $exam->title;
?>
<main class="exam-page<?= (isset($order) && $order) ? ' exam-page--owned' : '' ?>">
    <div class="container">
        <section class="section-hero section-hero--center exam-hero">
            <h1 class="page-title"><?= esc($exam->title) ?> Updated Exam Dumps</h1>
            <p class="page-lead"><?= esc($exam->name) ?></p>
        </section>

        <div class="exam-offer-strip">
            <div class="exam-offer-inner">
                <span class="exam-offer-head">Exclusive Offer Today!</span>
                <span class="exam-offer-text">Enjoy <strong>40%</strong> Discount on all Products.</span>
                <span class="exam-offer-code">Use Coupon Code: <strong>CL40</strong></span>
            </div>
        </div>

        <section class="exam-product">
            <div class="exam-product-grid">
                <div class="exam-product-image">
                    <img src="<?= base_url('uploads/p231.png') ?>" alt="<?= esc($exam->title) ?> Exam Dumps" loading="lazy">
                </div>
                <div class="exam-product-details content-card">
                    <?php
                    $rating = (float) ($exam->rating ?? 0);
                    $maxStars = 5;
                    $num_review = $exam->number_of_review ?? 0;
                    ?>
                    <div class="exam-rating">
                        <span class="exam-stars" aria-label="Rating: <?= $rating ?> out of 5">
                            <?php for ($i = 1; $i <= $maxStars; $i++) {
                                if ($rating >= $i) echo '<i class="fas fa-star"></i>';
                                elseif ($rating >= ($i - 0.5)) echo '<i class="fas fa-star-half-alt"></i>';
                                else echo '<i class="far fa-star"></i>';
                            } ?>
                        </span>
                        <span class="exam-review-count">(<?= (int)$num_review ?> customer reviews)</span>
                    </div>
                    <dl class="exam-meta">
                        <dt>Exam Code</dt><dd><strong><?= esc($exam->title) ?></strong></dd>
                        <dt>Questions with Answers (PDF)</dt><dd><strong><?= esc($exam->questions ?? '—') ?></strong></dd>
                        <dt>Last Updated</dt><dd><strong><?= date("F d, Y", strtotime($days_ago)) ?></strong></dd>
                    </dl>
                    <div class="exam-price">
                        <span class="exam-price-current">$35.50</span>
                        <span class="exam-price-was">$<?= format_money($exam->sale_price ?? 0) ?></span>
                    </div>
                    <div class="exam-actions">
                        <?= form_open('action/add_to_cart', ['class' => 'exam-form-cart']) ?>
                        <?= form_hidden('product', $exam->id) ?>
                        <?= form_hidden('sku', $exam->sku ?? '') ?>
                        <?= form_submit('submit', 'Add to Cart', ['class' => 'btn btn-cart btn-success exam-btn exam-btn--cart']) ?>
                        <?= form_close() ?>
                        <?php if (isset($order) && $order): ?>
                        <a href="<?= base_url("action/download/{$session->get('user_id')}/{$order}/{$exam->id}/{$exam->path_slug}") ?>" class="btn btn-success exam-btn exam-btn--download btn-download" download>Download</a>
                        <?php endif; ?>
                        <a href="#" class="btn btn-primary exam-btn exam-btn--demo" data-toggle="modal" data-target="#demoModal" id="demo_button" style="display:none;">Download Demo</a>
                    </div>
                </div>
                <div class="exam-trust">
                    <div class="exam-trust-item">
                        <img src="<?= base_url('uploads/icon4.png') ?>" alt="" width="60" height="60" loading="lazy">
                        <p><strong>100% Money Back Guarantee</strong></p>
                    </div>
                    <div class="exam-trust-item">
                        <img src="<?= base_url('uploads/icon5.png') ?>" alt="" width="60" height="60" loading="lazy">
                        <p><strong>Security and Privacy</strong></p>
                    </div>
                    <div class="exam-trust-item">
                        <img src="<?= base_url('uploads/icon6.png') ?>" alt="" width="60" height="60" loading="lazy">
                        <p><strong>24/7 Customer Service</strong></p>
                    </div>
                </div>
            </div>
        </section>

        <section class="features-strip mt-5">
            <div class="container">
                <div class="row align-items-stretch">
                    <div class="col-lg-3 col-md-6">
                        <div class="feature-card">
                            <div class="feature-icon"><i class="fa fa-refresh"></i></div>
                            <h3>Free 3 Months Updates</h3>
                            <p>CertsLeads offers 3 months free updates upon purchase. Once you buy any product you're subscribed to free updates.</p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="feature-card">
                            <div class="feature-icon"><i class="fa fa-headphones"></i></div>
                            <h3>24/7 Customer Support</h3>
                            <p>We offer 24/7 free customer support to make your learning smooth. Have a query? Feel free to write us.</p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="feature-card">
                            <div class="feature-icon"><i class="fa fa-shield"></i></div>
                            <h3>100% Money Back Guarantee</h3>
                            <p>Your investment is secured with CertsLeads. We offer a 100% refund policy so you're never at risk.</p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-md-6">
                        <div class="feature-card">
                            <div class="feature-icon"><i class="fa fa-download"></i></div>
                            <h3>Try Free Demo</h3>
                            <p>Try the free demo before purchase. Get acquainted with our actual product and format risk-free.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <section class="exam-content-section">
            <div class="exam-content-layout">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="exam-content-main content-card">
                            <h2 class="section-title">Pass <?= esc($category->name) ?> <?= esc($exam_title) ?> Authorization With Assessments Exam Guide</h2>
                            <p>We know that every association is different. We have created this platform for our <?= esc($category->name) ?> <?= esc($exam_title) ?> customers and provide you <?= esc($category->name) ?> <?= esc($exam_title) ?> authorization exam material here. It's an affordable platform for everyone to pass their online <?= esc($exam_title) ?> <?= esc($exam_name) ?> exam. Our aim is to help you pass your <?= esc($exam_title) ?> exam with good grades. You must go through the recommended preparation materials if you want to pass <?= esc($category->name) ?> <?= esc($exam_title) ?> authorization test. We provide updated material and our <?= esc($exam_title) ?> exam preparation material in PDF format.</p>
                            <h3 class="content-heading">How Can We Pass <?= esc($category->name) ?> <?= esc($exam_title) ?> Authorization Exam Dumps</h3>
                            <p>Our company provides a PDF format for <?= esc($category->name) ?> <?= esc($exam_title) ?> authorization exam material. It's reliable and easy to understand. We provide you a proper way of learning and self-evaluation so you can identify your weaknesses and improve.</p>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <aside class="exam-sidebar content-card">
                            <h3 class="section-title lined">Popular Exam Dumps List</h3>
                            <div id="vendorTabs" class="exam-tabs">
                                <ul class="resp-tabs-list exam-tabs-list">
                                    <?php foreach ($topvendors as $vc): ?><li><?= esc($vc->name) ?></li><?php endforeach; ?>
                                </ul>
                                <div class="resp-tabs-container">
                                    <?php foreach ($topvendors as $categories):
                                        $subcat = $Functions->subCats_by_parent($categories->id);
                                    ?><div class="exam-tabs-pane">
                                        <?php foreach ($subcat as $subcats):
                                            $exams_list = $Functions->topexam(12, null, $subcats->id);
                                            foreach ($exams_list as $rel_exam):
                                                $url_c = urlencode($categories->slug);
                                                $url_e = urlencode($rel_exam->slug);
                                        ?><a href="<?= base_url("{$url_c}/{$url_e}-exam-questions") ?>"><?= esc($rel_exam->title) ?></a>
                                        <?php endforeach; endforeach; ?></div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </aside>
                    </div>
                </div>
            </div>
        </section>

        <section class="exam-content-section exam-content-more">
            <div class="content-card">
                <h3 class="content-heading">Unique Way To Preparation <?= esc($exam_title) ?> Exam Dumps</h3>
                <p>We provide different aspects of preparing for <?= esc($category->name) ?> <?= esc($exam_title) ?> authorization exam. Our professionals prepared all material with detailed content covering the syllabus. Focus on the demo first, then start your <?= esc($exam_title) ?> exam preparation. We give you a 100% guarantee that you will pass your <?= esc($exam_title) ?> <?= esc($exam_name) ?> exam easily.</p>
                <h3 class="content-heading">90K Happy Customers</h3>
                <p>More than 90,000 people are happy with our <?= esc($category->name) ?> <?= esc($exam_title) ?> exam material because they cleared the <?= esc($exam_title) ?> exam on their first attempt.</p>
                <h3 class="content-heading"><?= esc($category->name) ?> <?= esc($exam_title) ?> Exam Dumps – 100% Money Back Guarantee</h3>
                <p>We take care of our <?= esc($exam_title) ?> customers. If someone fails even after their best efforts, we will give your money back. We are here to listen to every problem and provide a satisfied solution.</p>
            </div>
        </section>

        <div id="exam-listing-ajax" class="listing-section-ajax-placeholder" data-ajax-url="<?= base_url('home/exam-listing') ?>">
        <div class="listing-section listing-section--loading">
            <div class="container listing">
                <div class="row">
                    <div class="col-12 listing-section-header">
                        <h3 class="listing-section-title">2025 Updated Exam Questions</h3>
                        <p class="listing-section-lead">Browse by vendor and find the right exam dumps for your certification.</p>
                    </div>
                    <div class="col-12 updates text-center py-5">
                        <p class="listing-ajax-loading text-muted mb-0"><i class="fa fa-spinner fa-spin fa-2x" aria-hidden="true"></i></p>
                        <p class="listing-ajax-loading-text small text-muted mt-2">Loading exam questions...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
    </div>
</main>

<!-- Demo Download Modal -->
<div class="modal fade" id="demoModal" tabindex="-1" role="dialog" aria-labelledby="demoModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content content-card">
            <div class="modal-header">
                <h5 class="modal-title content-heading" id="demoModalLabel">Updated PDF Questions &amp; Answers Demo</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <p><strong>Features Of Certsleads:</strong></p>
                        <ul class="exam-modal-features">
                            <li><img src="<?= base_url('uploads/t.png') ?>" width="15" height="15" alt=""> After Purchase Instant Downloads</li>
                            <li><img src="<?= base_url('uploads/t.png') ?>" width="15" height="15" alt=""> You Can Easily Print Our PDFs</li>
                            <li><img src="<?= base_url('uploads/t.png') ?>" width="15" height="15" alt=""> 100% Money Back Guarantee</li>
                            <li><img src="<?= base_url('uploads/t.png') ?>" width="15" height="15" alt=""> Get 90 Days Free Updates</li>
                            <li><img src="<?= base_url('uploads/t.png') ?>" width="15" height="15" alt=""> 24/7 Customer Support</li>
                            <li><img src="<?= base_url('uploads/t.png') ?>" width="15" height="15" alt=""> Try Free Demos Any Certification Exams</li>
                            <li><img src="<?= base_url('uploads/t.png') ?>" width="15" height="15" alt=""> Verified &amp; Updated Questions &amp; Answers</li>
                        </ul>
                    </div>
                    <div class="col-md-6">
                        <div id="success" class="exam-modal-success" style="display:none;">Thank you for downloading your demo.</div>
                        <form id="demo_pop_up_download" method="post">
                            <input type="text" class="form-control exam-input" name="name_popup" id="name_popup" placeholder="Enter Your Name" required>
                            <input type="hidden" name="exam_id" value="<?= (int)$exam->id ?>">
                            <input type="email" class="form-control exam-input" name="emailid_popup" id="emailid_popup" placeholder="Enter Email ID" required>
                            <button type="submit" class="btn btn-block exam-btn exam-btn--primary">Download Demo</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#demo_button').show();
    $('#demo_pop_up_download').on('submit', function(e) {
        e.preventDefault();
        $.ajax({
            url: '<?= base_url('action/save_email_id') ?>',
            data: $(this).serialize(),
            type: 'POST',
            success: function() {
                $('#demo_pop_up_download input:text, #demo_pop_up_download input[type=email]').val('');
                $('#emailid_popup').val('');
                $('#success').show();
                window.location = "<?= base_url("action/demo_download/{$exam->id}/{$exam->demo_slug}") ?>";
            },
            error: function() {
                $('#error').show().fadeOut(10000);
            }
        });
    });
});
</script>

<script>
(function() {
    var placeholder = document.getElementById('exam-listing-ajax');
    if (!placeholder) return;
    var url = placeholder.getAttribute('data-ajax-url');
    if (!url) return;
    fetch(url, { credentials: 'same-origin' })
        .then(function(r) { return r.text(); })
        .then(function(html) {
            if (html) {
                var wrap = document.createElement('div');
                wrap.innerHTML = html.trim();
                var section = wrap.firstChild;
                if (section) placeholder.parentNode.replaceChild(section, placeholder);
            }
        })
        .catch(function() {
            var err = document.createElement('section');
            err.className = 'listing-section';
            err.innerHTML = '<div class="container"><div class="row"><div class="col-12 text-center py-5 text-muted">Unable to load exam listing. <a href="">Refresh the page</a>.</div></div></div>';
            err.querySelector('a').href = window.location.href;
            placeholder.parentNode.replaceChild(err, placeholder);
        });
})();
</script>
<?php echo view('default/includes/footer', get_defined_vars()); ?>
