<?php
/**
 * Partial: Exam listing section (loaded via AJAX for home page).
 * Expects: $hotvendors, $Functions
 */
?>
<section class="listing-section">
    <div class="container listing">
        <div class="row">
            <div class="col-12 listing-section-header">
                <h3 class="listing-section-title">2025 Updated Exam Questions</h3>
                <p class="listing-section-lead">Browse by vendor and find the right exam dumps for your certification.</p>
            </div>
            <div class="col-12 updates">
                <div class="content listing-vendor-sections">
                    <?php foreach ($hotvendors as $category):
                        $subcat = $Functions->subCats_by_parent($category->id);
                        ?>
                        <section class="vendor-exam-section">
                            <h4 class="vendor-exam-section-title"><?= $category->name ?></h4>
                            <div class="exam-grid">
                                <?php foreach ($subcat as $subcats):
                                    $exams = $Functions->hotexam(12, null, $subcats->id);
                                    ?>
                                    <?php foreach ($exams as $exam) {
                                        $url_c = urlencode($category->slug);
                                        $url_e = urlencode($exam->slug);
                                        ?>
                                        <a href="<?= base_url("{$url_c}/{$url_e}") ?>-exam-questions" class="exam-card">
                                            <span class="exam-card-title"><?= $exam->title ?> Exam Questions</span>
                                            <span class="exam-card-cta seedetail">See Detail <i class="fa fa-arrow-right" aria-hidden="true"></i></span>
                                        </a>
                                    <?php } ?>
                                <?php endforeach; ?>
                            </div>
                        </section>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>
