<?php
echo view('default/includes/header', get_defined_vars());
echo view('default/includes/topbarNavigation', get_defined_vars());
$cats = $Functions->categories_front_all('all', 0);
$catsearch = $Functions->categories_front_all('parent', 0);
$topCategories = $Functions->categories('all', 5);
$topvendors = $Functions->topvendor();
?>
<main class="home-page">
    <!-- Hero (image-style: dark teal, left text + search, right circular image, wavy divider) -->
    <section class="hero-section hero-banner">
        <div class="hero-bg-pattern"></div>
        <div class="hero-accent-grid" aria-hidden="true"></div>
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-7 col-12">
                    <div class="hero-content">
                        <h1 class="hero-headline">
                            <span class="hero-line">PASS YOUR</span>
                            <span class="hero-line hero-line-lg">CERTIFICATION</span>
                            <span class="hero-line hero-accent">EXAM 2025</span>
                        </h1>
                        <p class="lead">Get actual exam questions, free demos, and 3 months of updates. Try our material risk-free with a 100% money-back guarantee.</p>
                        <form class="hero-search-form" method="get" action="<?= base_url('s'); ?>">
                            <div class="hero-search-wrap">
                                <input type="text" class="hero-search-input" name="q" placeholder="Search exams..." required>
                                <button type="submit" class="hero-search-btn" aria-label="Search">
                                    <i class="fa fa-search"></i>
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-lg-5 col-md-5 col-12 text-center text-md-end">
                    <div class="hero-circle-img">
                        <?php if (is_file(FCPATH . 'uploads/single-slide-1.png')): ?>
                            <img src="<?= base_url('uploads/single-slide-1.png'); ?>" alt="CertsLeads">
                        <?php else: ?>
                            <img src="<?= base_url('uploads/CertsLeads.png'); ?>" alt="CertsLeads">
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
        <div class="hero-wave">
            <svg viewBox="0 0 1440 100" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="none">
                <path d="M0 50 Q360 0 720 50 T1440 50 L1440 100 L0 100 Z" fill="white"/>
            </svg>
        </div>
    </section>

    <!-- Download Demo strip (below hero wave) -->
    <section class="hero-demo-strip" aria-labelledby="demo-strip-heading">
        <div class="container">
            <div class="demo-card">
                <div class="row align-items-center">
                    <div class="col-lg-7 col-md-6">
                        <div class="demo-strip-copy">
                            <div class="demo-strip-icon" aria-hidden="true"><i class="fa fa-download"></i></div>
                            <h2 id="demo-strip-heading" class="demo-strip-title">Download Free Demo</h2>
                            <p class="demo-strip-text">Select vendor &amp; exam, enter your email — get instant access to a free demo. No credit card required.</p>
                        </div>
                    </div>
                    <div class="col-lg-5 col-md-6 mt-4 mt-md-0">
                        <div class="demo-strip-form-wrap">
                            <?= form_open('action/download_demo', ['class' => 'demo-strip-form']); ?>
                            <div class="form-group">
                                <label for="vendor" class="demo-strip-label">Vendor</label>
                                <select class="form-control demo-strip-input" name="vendor" id="vendor" required>
                                    <option value="">Select Vendor</option>
                                    <?php foreach ($catsearch as $cat): ?>
                                        <option value="<?= $cat->slug ?>"><?= $cat->name ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="exam" class="demo-strip-label">Exam</label>
                                <div id="exam_combo">
                                    <select class="form-control demo-strip-input" name="exam" id="exam" required>
                                        <option value="">Select Exam</option>
                                    </select>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="demo-email" class="demo-strip-label">Email</label>
                                <input class="form-control demo-strip-input" type="email" name="email" id="demo-email" placeholder="your@email.com" required value="">
                            </div>
                            <button type="submit" class="btn btn-demo btn-block">
                                <i class="fa fa-download demo-btn-icon" aria-hidden="true"></i>Download Demo
                            </button>
                            <?= form_close(); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Features strip (Choose Us) -->
    <section class="features-strip mt-5">
        <div class="container">
            <div class="row align-items-stretch">
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon"><i class="fa fa-refresh"></i></div>
                        <h3>Free 3 Months Updates</h3>
                        <p>CertsLeads offers 3 months free updates upon purchase. Once you buy any product you're subscribed to free updates.</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon"><i class="fa fa-headphones"></i></div>
                        <h3>24/7 Customer Support</h3>
                        <p>We offer 24/7 free customer support to make your learning smooth. Have a query? Feel free to write us.</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon"><i class="fa fa-shield"></i></div>
                        <h3>100% Money Back Guarantee</h3>
                        <p>Your investment is secured with CertsLeads. We offer a 100% refund policy so you're never at risk.</p>
                    </div>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="feature-card">
                        <div class="feature-icon"><i class="fa fa-download"></i></div>
                        <h3>Try Free Demo</h3>
                        <p>Try the free demo before purchase. Get acquainted with our actual product and format risk-free.</p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Why Choose Us - infographic style: large gray circle, purple title circle, feature list with connecting lines -->
    <section class="why-section why-section-infographic">
        <div class="container">
            <div class="why-circle-bg">
                <div class="why-title-badge">
                    <span class="why-title-line1">WHY</span>
                    <span class="why-title-line2">CHOOSE</span>
                    <span class="why-title-line3">US</span>
                </div>
                <div class="why-intro">
                    <p>Thousands of professionals trust CertsLeads for certification prep. We deliver real exam questions, free demos, and 3 months of updates with a 100% money-back guarantee.</p>
                    <p>Choose from a wide library including Microsoft, Cisco, CompTIA, Oracle, IBM and more. Try before you buy—download a free demo today.</p>
                </div>
                <div class="why-features">
                    <div class="why-feature why-feature--1">
                        <div class="why-feature-icon"><i class="fa fa-check-circle"></i></div>
                        <span class="why-feature-line"></span>
                        <div class="why-feature-content">
                            <h3>100% Real Questions</h3>
                            <p>We verify that 100% of the questions in our exam prep package are real questions from recent test versions.</p>
                        </div>
                    </div>
                    <div class="why-feature why-feature--2">
                        <div class="why-feature-icon"><i class="fa fa-clock"></i></div>
                        <span class="why-feature-line"></span>
                        <div class="why-feature-content">
                            <h3>Fairly Priced</h3>
                            <p>CertsLeads exam dumps never cost you much. Try as many certifications as you want for your IT career.</p>
                        </div>
                    </div>
                    <div class="why-feature why-feature--3">
                        <div class="why-feature-icon"><i class="fa fa-hand-pointer"></i></div>
                        <span class="why-feature-line"></span>
                        <div class="why-feature-content">
                            <h3>Free 3 Months Updates</h3>
                            <p>Once you buy any of our products you will be subscribed to free updates for 3 months.</p>
                        </div>
                    </div>
                    <div class="why-feature why-feature--4">
                        <div class="why-feature-icon"><i class="fa fa-file-lines"></i></div>
                        <span class="why-feature-line"></span>
                        <div class="why-feature-content">
                            <h3>Accurate & Updated</h3>
                            <p>Each certification package and question is authentic. Material is consistently updated for existing and new certifications.</p>
                        </div>
                    </div>
                    <div class="why-feature why-feature--5">
                        <div class="why-feature-icon"><i class="fa fa-undo"></i></div>
                        <span class="why-feature-line"></span>
                        <div class="why-feature-content">
                            <h3>Money Back Guarantee</h3>
                            <p>Zero risk. Claim your refund if our study resources haven't lived up to what we promise. 100% money back if you don't pass.</p>
                        </div>
                    </div>
                    <div class="why-feature why-feature--6">
                        <div class="why-feature-icon"><i class="fa fa-heart"></i></div>
                        <span class="why-feature-line"></span>
                        <div class="why-feature-content">
                            <h3>Security and Privacy</h3>
                            <p>Free demo downloads so you can see what we have in store. Thousands buy right after checking our free demos.</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- FAQ / Content block -->
    <section class="content-block content-block--faq">
        <div class="container">
            <div class="content-block-inner">
                <div class="content">
                    <?php echo $Functions->get_db_option('section_home1'); ?>
                    <h1 class="content-block-title">How to pass net certification test from CERTSLEAD</h1>
                    <p>We provide a very easy and convenient way to pass this net certification test. You can go through our exam material and easily pass this exam. We provide material according to the exam criteria. First get the questions file, read all questions sincerely and prepare yourself. We are sure after this you will clear this exam. Trust is the most important thing—have trust in us; we are sure you will pass. We provide a money back guarantee. If someone fails, we give your money back. Our PDF file is convenient to use and updated. We provide 3 months free updates and many facilities to our customers.</p>
                    <h2>Updated and latest exam Questions</h2>
                </div>
            </div>
        </div>
    </section>

    <!-- Testimonial / Prep content block -->
    <section class="content-block content-block--alt">
        <div class="container">
            <div class="content-block-inner">
                <div class="content">
                    <?php echo $Functions->get_db_option('section_home2'); ?>
                    <p>We give you an auspicious and ideal chance for all willing customers who want to clear this certification exam. Our team provides an accurate file of all questions related to the exam. This course will be very helpful and save your time, especially for those with a short preparation period. You can pass the exam through this course in a short time. We give you surety that this exam material is enough for your preparation—no need to buy other books. Go through our exam material; we give you 100% guarantee to pass. Our material will save your money, time and expenses. We provide an easy format so you can easily read all questions.</p>
                    <h3>Certification Exam Preparation In PDF Format</h3>
                    <p>If you are interested in the certification exam and have trouble finding a good way to prepare, visit us. Our team provides a proper plan to pass the exam. Our exam material is in PDF format—easy to understand and well-organized. No one wants to face difficulties during preparation. We are here to solve all your problems related to the certification exam. Our PDF format is small in size and you can easily send it via email. It works on any computer or electronic device.</p>
                </div>
            </div>
        </div>
    </section>

    <!-- Achievement & Testimonials -->
    <section class="stats-section" aria-labelledby="achievement-heading">
        <div class="container">
            <div class="section-title-wrap">
                <h2 id="achievement-heading">Our Achievement</h2>
            </div>
            <div class="stats-grid row">
                <div class="col-6 col-lg-3 mb-4 mb-lg-0">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <?php if (is_file(FCPATH . 'lib/assets/img/icon-img/achieve-1.png')): ?>
                                <img src="<?= base_url('lib/assets/img/icon-img/achieve-1.png'); ?>" alt="">
                            <?php else: ?>
                                <i class="fa fa-database" aria-hidden="true"></i>
                            <?php endif; ?>
                        </div>
                        <div class="stat-value">3000+</div>
                        <div class="stat-label">Valid Dumps</div>
                    </div>
                </div>
                <div class="col-6 col-lg-3 mb-4 mb-lg-0">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <?php if (is_file(FCPATH . 'lib/assets/img/icon-img/achieve-2.png')): ?>
                                <img src="<?= base_url('lib/assets/img/icon-img/achieve-2.png'); ?>" alt="">
                            <?php else: ?>
                                <i class="fa fa-users" aria-hidden="true"></i>
                            <?php endif; ?>
                        </div>
                        <div class="stat-value">90,000</div>
                        <div class="stat-label">Satisfied Customers</div>
                    </div>
                </div>
                <div class="col-6 col-lg-3 mb-4 mb-lg-0">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <?php if (is_file(FCPATH . 'lib/assets/img/icon-img/achieve-3.png')): ?>
                                <img src="<?= base_url('lib/assets/img/icon-img/achieve-3.png'); ?>" alt="">
                            <?php else: ?>
                                <i class="fa fa-check-circle" aria-hidden="true"></i>
                            <?php endif; ?>
                        </div>
                        <div class="stat-value">96%</div>
                        <div class="stat-label">Success Rate</div>
                    </div>
                </div>
                <div class="col-6 col-lg-3 mb-4 mb-lg-0">
                    <div class="stat-card">
                        <div class="stat-icon">
                            <?php if (is_file(FCPATH . 'lib/assets/img/icon-img/achieve-4.png')): ?>
                                <img src="<?= base_url('lib/assets/img/icon-img/achieve-4.png'); ?>" alt="">
                            <?php else: ?>
                                <i class="fa fa-refresh" aria-hidden="true"></i>
                            <?php endif; ?>
                        </div>
                        <div class="stat-value">99%</div>
                        <div class="stat-label">Updated Exams</div>
                    </div>
                </div>
            </div>

            <div class="testimonial-slider-wrap">
                <h3 class="testimonial-section-title">What Our Customers Say</h3>
                <p class="testimonial-section-lead">Real feedback from people who passed their exams with CertsLeads.</p>
                <div class="testimonial-card-and-nav">
                    <div class="testimonial-text-slider">
                    <div class="testi-content-wrap">
                        <div class="testi-content">
                            <blockquote class="testi-blockquote">
                                <p class="testi-text">300-075 PDF exams questions were excellent so I'll strongly recommend you to utilize this opportunity. The questions were great and properly helped me prepare for the Cisco 300-075 exam, which I cleared! Thanks CertsLeads!</p>
                            </blockquote>
                            <div class="testi-author">
                                <img class="testi-avatar" src="<?= base_url('lib/assets/img/testimonial/testi-s2.jpg'); ?>" alt="">
                                <div class="testi-info">
                                    <h5 class="testi-name">Fumiko Cox</h5>
                                    <span class="testi-role">Students Of Science Department</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="testi-content-wrap">
                        <div class="testi-content">
                            <blockquote class="testi-blockquote">
                                <p class="testi-text">I bought PDF exams for 220-1001 CompTIA dumps. I received a passing status! I would definitely recommend these PDF 220-1001 exam dumps. They helped me in preparation for my CompTIA 220-1001 exams. CertsLeads PDF tests are an awesome resource.</p>
                            </blockquote>
                            <div class="testi-author">
                                <img class="testi-avatar" src="<?= base_url('lib/assets/img/testimonial/testi-s1.jpg'); ?>" alt="">
                                <div class="testi-info">
                                    <h5 class="testi-name">Catalina King</h5>
                                    <span class="testi-role">Students Of Computer Science Department</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="testi-content-wrap">
                        <div class="testi-content">
                            <blockquote class="testi-blockquote">
                                <p class="testi-text">I like these PDF exams because they are just like the actual Microsoft AZ-300 exam. They give you similar problems to work out and help you understand what will be on the AZ-300 exam dumps.</p>
                            </blockquote>
                            <div class="testi-author">
                                <img class="testi-avatar" src="<?= base_url('lib/assets/img/testimonial/tesi12.jpg'); ?>" alt="">
                                <div class="testi-info">
                                    <h5 class="testi-name">Candice Kramer</h5>
                                    <span class="testi-role">Students Of Information Technology</span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="testi-content-wrap">
                        <div class="testi-content">
                            <blockquote class="testi-blockquote">
                                <p class="testi-text">Not so Bad. Some questions/answers are outdated, but most are updated. Overall I have a neutral review about CertsLeads. Next time I would like all questions/answers updated to current Oracle 1Z0-1028 exam dumps.</p>
                            </blockquote>
                            <div class="testi-author">
                                <img class="testi-avatar" src="<?= base_url('lib/assets/img/testimonial/testi-s3.jpg'); ?>" alt="">
                                <div class="testi-info">
                                    <h5 class="testi-name">Milton Wells</h5>
                                    <span class="testi-role">Students Of Oracle Certified Department</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Hot vendors / Exam listing (loaded via AJAX to reduce initial page load) -->
    <div id="exam-listing-ajax" class="listing-section-ajax-placeholder" data-ajax-url="<?= base_url('home/exam-listing') ?>">
        <div class="listing-section listing-section--loading">
            <div class="container listing">
                <div class="row">
                    <div class="col-12 listing-section-header">
                        <h3 class="listing-section-title">2025 Updated Exam Questions</h3>
                        <p class="listing-section-lead">Browse by vendor and find the right exam dumps for your certification.</p>
                    </div>
                    <div class="col-12 updates text-center py-5">
                        <p class="listing-ajax-loading text-muted mb-0"><i class="fa fa-spinner fa-spin fa-2x" aria-hidden="true"></i></p>
                        <p class="listing-ajax-loading-text small text-muted mt-2">Loading exam questions...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<script>
(function() {
    var placeholder = document.getElementById('exam-listing-ajax');
    if (!placeholder) return;
    var url = placeholder.getAttribute('data-ajax-url');
    if (!url) return;
    fetch(url, { credentials: 'same-origin' })
        .then(function(r) { return r.text(); })
        .then(function(html) {
            if (html) {
                var wrap = document.createElement('div');
                wrap.innerHTML = html.trim();
                var section = wrap.firstChild;
                if (section) placeholder.parentNode.replaceChild(section, placeholder);
            }
        })
        .catch(function() {
            var err = document.createElement('section');
            err.className = 'listing-section';
            err.innerHTML = '<div class="container"><div class="row"><div class="col-12 text-center py-5 text-muted">Unable to load exam listing. <a href="">Refresh the page</a>.</div></div></div>';
            err.querySelector('a').href = window.location.href;
            placeholder.parentNode.replaceChild(err, placeholder);
        });
})();
</script>
<?php echo view('default/includes/footer', get_defined_vars()); ?>