<?php
// Get all categories
$categories = $Functions->categories('parent', 20, false);
?>
<header>
    <div class="topbarNavWrap container">
        <div class="row topbarNav">
            <div class="logo col-sm-12 col-md-4">
                <a href="<?php echo base_url(); ?>">
                    <?php
                    $logo = $Functions->get_db_option('logoUrl');
                    ?>
                    <img src="<?php echo base_url("/uploads/{$logo}"); ?>" alt="Logo">
                </a>
            </div>
            <div class="navigation col-sm-12 col-md-8">
                <div class="head-row">
                    <div class="homeLink">
                        <a href="<?php echo base_url(); ?>">Home</a>
                    </div>
                </div>
                <div class="head-row">
                    <div class="navDropper categories">
                        <a href="<?= base_url("all") ?>">Vendors</a>
                    </div>
                    <a href="<?php echo base_url('/cart') ?>" class="cart">
                        <i class="fa fa-shopping-cart"></i> <span class="amout"><?php echo cart_total_items($cart); ?></span>
                    </a>
                </div>
                <div class="head-row">
                    <div class="searchWrap">
                        <form type="GET" action="<?= base_url("s") ?>">
                            <div class="form-group">
                              <div class="input-group">
                                <input type="text" class="form-control" placeholder="Search" name="q">
                                <span class="input-group-btn">
                                  <button class="btn btn-default" type="submit" role="submit">
                                      <i class="fa fa-search"></i>
                                  </button>
                                </span>
                              </div>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="head-row">
                    <div class="accountLinks">
                        <div class="btn-group btn-group-justified">
                        <?php if($session->get('user_id')): ?>
                              <a href="<?php echo base_url('account') ?>" class="btn btn-default">My Account</a>
                              <a href="<?php echo base_url('action/session/destroy') ?>" class="btn btn-default">Logout</a>
                        <?php else: ?>
                              <a href="<?php echo base_url('account/signin') ?>" class="btn btn-default">Sign In</a>
                              <a href="<?php echo base_url('account/register') ?>" class="btn btn-default">Register</a>
                        <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</header>
<?php
$c = ($router_controller ?? '');
$m = ($router_method ?? '');
$routes = array(
        array('url'=>base_url(), 'name'=>'Home')
    );
if($c !== 'home'):
    switch ($c) {
        case 'account':
            if($m == 'signin') {
                array_push($routes, array('name'=>'Sign In'));
            } elseif($m == 'register') {
                array_push($routes, array('name'=>'Register'));
            }
            break;
        case 'action':
            if($m == 'signin') {
                array_push($routes, array('name'=>'Sign In'));
            } elseif($m == 'register') {
                array_push($routes, array('name'=>'Register'));
            }
            break;
        
        case 'vendor':
            if($m == 'single') {
                array_push($routes, array('name'=>$category->name));
            }
            break;
            
        case 'Exam':
            if($m == 'single') {
                array_push($routes, array('name'=>$category->name, 'url'=>base_url("vendor/{$category->slug}")));
                array_push($routes, array('name'=>$exam->title));
            }
            break;
            
        case 'See':
            if($m == 'cart') {
                array_push($routes, array('name'=>'Cart'));
            } else {
                array_push($routes, array('name'=>$title));
            }
            break;
        
        default:
            // code...
            break;
    }
?>
    <div class="breadcrumb">
        <div class="container">
            <ul>
                <?php foreach($routes as $route): ?>
                <li>
                    <?php if(isset($route['url']) && $route['url'] !== ''): ?>
                    <a href="<?php echo $route['url'] ?>"><?php echo $route['name']  ?></a>
                    <?php else: ?>
                    <span><?php echo $route['name']  ?></span>
                    <?php endif; ?>
                </li>
                <?php endforeach; ?>
            </ul>
        </div>
    </div>
<?php
endif; ?>
<div class="clearfix"></div>
