<?php
echo view('default/includes/header', get_defined_vars());
echo view('default/includes/topbarNavigation', get_defined_vars());

$loginCodes = ['email' => 'Please enter a valid email.', 'password' => 'Please enter your password.', 'invalid' => 'Invalid Email/Password.'];
$regCodes   = ['recaptcha' => 'reCAPTCHA verification failed. Please try again.', 'email' => 'Please enter a valid email.', 'name' => 'Please enter your name.', 'password' => 'Password is required (min 4 characters).', 'match' => 'Passwords do not match.', 'exists' => 'A user with this email already exists.', 'failed' => 'Registration failed. Please try again.'];
$le = isset($_GET['login_error']) && isset($loginCodes[$_GET['login_error']]) ? $loginCodes[$_GET['login_error']] : '';
$re = isset($_GET['register_error']) && isset($regCodes[$_GET['register_error']]) ? $regCodes[$_GET['register_error']] : '';
?>

<section class="auth-section">
    <div class="container">
        <!-- Error Messages -->
        <?php if ($le !== '' || $re !== ''): ?>
        <div class="auth-alert">
            <div class="auth-alert-icon">
                <i class="fa fa-exclamation-circle"></i>
            </div>
            <div class="auth-alert-content">
                <?php if ($le !== ''): ?>
                    <div class="auth-alert-item">
                        <strong>Sign In Error:</strong> <?= htmlspecialchars($le, ENT_QUOTES, 'UTF-8') ?>
                    </div>
                <?php endif; ?>
                <?php if ($re !== ''): ?>
                    <div class="auth-alert-item">
                        <strong>Registration Error:</strong> <?= htmlspecialchars($re, ENT_QUOTES, 'UTF-8') ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
        <?php endif; ?>

        <!-- Auth Cards Container -->
        <div class="auth-container">
            <!-- Sign In Card -->
            <div class="auth-card">
                <div class="auth-card-header">
                    <div class="auth-card-icon">
                        <i class="fa fa-sign-in" style="font-size: 3rem !important;"></i>
                    </div>
                    <h2 class="auth-card-title">Sign In</h2>
                    <p class="auth-card-subtitle">Welcome back! Please sign in to your account</p>
                </div>

                <form name="sign-in" class="auth-form" id="test" action="<?php echo base_url(); ?>action/session/create?next=<?php echo urlencode($next ?? ''); ?>" method="post" accept-charset="utf-8">
                    <div class="auth-form-group">
                        <label class="auth-label">
                            <i class="fa fa-envelope"></i> Email Address
                        </label>
                        <?php echo form_input('email', set_value('email'), array('class'=>'auth-input', 'placeholder'=>'Enter your email address' )); ?>
                    </div>

                    <div class="auth-form-group">
                        <label class="auth-label">
                            <i class="fa fa-lock"></i> Password
                        </label>
                        <?php echo form_password('password', '', array('class'=>'auth-input', 'placeholder'=>'Enter your password' )); ?>
                    </div>

                    <div class="auth-form-footer">
                        <a href="<?php echo base_url() ?>action/forget" class="auth-link">
                            <i class="fa fa-question-circle"></i> Forgot Password?
                        </a>
                    </div>

                    <button type="submit" class="auth-btn auth-btn--primary">
                        <i class="fa fa-sign-in"></i> Sign In
                    </button>
                </form>
            </div>

            <!-- Divider -->
            <div class="auth-divider">
                <div class="auth-divider-line"></div>
                <div class="auth-divider-text">OR</div>
                <div class="auth-divider-line"></div>
            </div>

            <!-- Register Card -->
            <div class="auth-card">
                <div class="auth-card-header">
                    <div class="auth-card-icon auth-card-icon--register">
                        <i class="fa fa-user-plus"  style="font-size: 3rem !important;"></i>
                    </div>
                    <h2 class="auth-card-title">Sign Up</h2>
                    <p class="auth-card-subtitle">Join us today and start your certification journey</p>
                </div>

                <form name="register" class="auth-form" action="<?php echo base_url(); ?>action/registers?next=<?php echo urlencode($next ?? ''); ?>" method="post" accept-charset="utf-8">
                    <div class="auth-form-row">
                        <div class="auth-form-group">
                            <label class="auth-label">
                                <i class="fa fa-user"></i> Full Name
                            </label>
                            <?php echo form_input('name', set_value('name'), array('class'=>'auth-input', 'placeholder'=>'Enter your full name' )); ?>
                        </div>

                        <div class="auth-form-group">
                            <label class="auth-label">
                                <i class="fa fa-envelope"></i> Email Address
                            </label>
                            <?php echo form_input('email', set_value('email'), array('class'=>'auth-input', 'placeholder'=>'Enter your email' )); ?>
                        </div>
                    </div>

                    <div class="auth-form-row">
                        <div class="auth-form-group">
                            <label class="auth-label">
                                <i class="fa fa-lock"></i> Password
                            </label>
                            <?php echo form_password('password', '', array('class'=>'auth-input', 'placeholder'=>'Create a password' )); ?>
                        </div>

                        <div class="auth-form-group">
                            <label class="auth-label">
                                <i class="fa fa-lock"></i> Confirm Password
                            </label>
                            <?php echo form_password('confirmPassword', '', array('class'=>'auth-input', 'placeholder'=>'Confirm your password' )); ?>
                        </div>
                    </div>

                    <input type="hidden" name="recaptcha_response" id="recaptchaResponse">

                    <button type="submit" class="auth-btn auth-btn--secondary">
                        <i class="fa fa-user-plus"></i> Create Account
                    </button>

                    <div class="auth-note">
                        <i class="fa fa-info-circle"></i>
                        By registering, you agree to our Terms of Service and Privacy Policy
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>

<script src="https://www.google.com/recaptcha/api.js?render=6LeEYPArAAAAAApVW45MSSyf4AcbUXcns8fROUEV"></script>
<script>
grecaptcha.ready(function() {
    grecaptcha.execute('6LeEYPArAAAAAApVW45MSSyf4AcbUXcns8fROUEV', {action: 'register'})
    .then(function(token) {
        document.getElementById('recaptchaResponse').value = token;
    });
});
</script>

<?php echo view('default/includes/footer', get_defined_vars());
