<?php
echo view('default/includes/header', get_defined_vars());
echo view('default/includes/topbarNavigation', get_defined_vars());
$testimonials = $Functions->testimonials();
?>
    <section id="content" class="testimonials-page">
        <div class="container">
            <!-- Page Hero -->
            <div class="section-hero section-hero--center">
                <h1 class="page-title">CertsLeads User's Testimonials</h1>
                <p class="page-lead">Hear what customers are saying about us</p>
            </div>

            <!-- Testimonials Grid -->
            <div class="testimonials-grid">
                <?php foreach($testimonials as $tt) { ?>
                    <div class="testimonial-page-card">
                        <div class="testimonial-page-quote">
                            <i class="fa fa-quote-left"></i>
                        </div>
                        <p class="testimonial-page-text"><?php echo $tt->text ?></p>
                        <div class="testimonial-page-author">
                            <div class="testimonial-page-avatar">
                                <?php echo strtoupper(substr($tt->name, 0, 1)) ?>
                            </div>
                            <div class="testimonial-page-info">
                                <h4 class="testimonial-page-name"><?php echo $tt->name ?></h4>
                                <span class="testimonial-page-title"><?php echo $tt->title ?></span>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>

            <!-- Submit Testimonial Form -->
            <div class="testimonial-submit-section">
                <div class="testimonial-submit-card">
                    <div class="testimonial-submit-header">
                        <h2 class="section-title">Share Your Experience</h2>
                        <p class="testimonial-submit-lead">We'd love to hear about your experience with CertsLeads</p>
                    </div>
                    <form method="post" action="create_testimonial" class="testimonial-form">
                        <input type="hidden" name="from_user" value="1">
                        
                        <div class="form-group">
                            <label class="form-label">Name <span class="required">*</span></label>
                            <input type="text" name="testimonial_name" id="testimonial_name" class="form-control" required placeholder="Enter Your Name"/>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Title <span class="required">*</span></label>
                            <input type="text" name="title" id="title" class="form-control" required placeholder="Your Job Title or Role"/>
                        </div>

                        <div class="form-group">
                            <label class="form-label">Message <span class="required">*</span></label>
                            <textarea class="form-control" name="testimonial_text" id="testimonial_text" required placeholder="Share your experience with us..."></textarea>
                        </div>

                        <button type="submit" class="btn-submit-testimonial">
                            <i class="fa fa-paper-plane"></i> Submit Testimonial
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>
<?php echo view('default/includes/footer', get_defined_vars()); ?>
