// Easy Responsive Tabs Plugin
// Author: Samson.Onna <Email : samson3d@gmail.com>
(function($) {
    $.fn.extend({
        easyResponsiveTabs: function(options) {
            //Set the default values, use comma to separate the settings, example:
            var defaults = {
                    type: 'default', //default, vertical, accordion;
                    width: 'auto',
                    fit: true,
                    closed: false,
                    activate: function() {}
                }
                //Variables
            var options = $.extend(defaults, options);
            var opt = options,
                jtype = opt.type,
                jfit = opt.fit,
                jwidth = opt.width,
                vtabs = 'vertical',
                accord = 'accordion';

            //Events
            $(this).bind('tabactivate', function(e, currentTab) {
                if (typeof options.activate === 'function') {
                    options.activate.call(currentTab, e)
                }
            });

            //Main function
            this.each(function() {
                var $respTabs = $(this);
                var $respTabsList = $respTabs.find('ul.resp-tabs-list1');
                $respTabs.find('ul.resp-tabs-list1 li').addClass('resp-tab-item1');
                $respTabs.css({
                    'display': 'block',
                    'width': jwidth
                });

                $respTabs.find('.resp-tabs-container1 > div').addClass('resp-tab-content1');
                jtab_options();
                //Properties Function
                function jtab_options() {
                    if (jtype == vtabs) {
                        $respTabs.addClass('resp-vtabs1');
                    }
                    if (jfit == true) {
                        $respTabs.css({
                            width: '100%',
                            margin: '0px'
                        });
                    }
                    if (jtype == accord) {
                        $respTabs.addClass('resp-easy-accordion1');
                        $respTabs.find('.resp-tabs-list1').css('display', 'none');
                    }
                }

                //Assigning the h2 markup to accordion title
                var $tabItemh2;
                $respTabs.find('.resp-tab-content1').before("<h2 class='resp-accordion1' role='tab'><span class='resp-arrow1'></span></h2>");

                var itemCount = 0;
                $respTabs.find('.resp-accordion1').each(function() {
                    $tabItemh2 = $(this);
                    var innertext = $respTabs.find('.resp-tab-item:eq(' + itemCount + ')').html();
                    $respTabs.find('.resp-accordion:eq(' + itemCount + ')').append(innertext);
                    $tabItemh2.attr('aria-controls1', 'tab_item-' + (itemCount));
                    itemCount++;
                });

                //Assigning the 'aria-controls1' to Tab items
                var count = 0,
                    $tabContent;
                $respTabs.find('.resp-tab-item1').each(function() {
                    $tabItem = $(this);
                    $tabItem.attr('aria-controls1', 'tab_item-' + (count));
                    $tabItem.attr('role', 'tab');

                    //First active tab, keep closed if option = 'closed' or option is 'accordion' and the element is in accordion mode 
                    if (options.closed !== true && !(options.closed === 'accordion' && !$respTabsList.is(':visible')) && !(options.closed === 'tabs' && $respTabsList.is(':visible'))) {
                        $respTabs.find('.resp-tab-item1').first().addClass('resp-tab-active1');
                        $respTabs.find('.resp-accordion1').first().addClass('resp-tab-active1');
                        $respTabs.find('.resp-tab-content1').first().addClass('resp-tab-content-active1').attr('style', 'display:block');
                    }

                    //Assigning the 'aria-labelledby' attr to tab-content
                    var tabcount = 0;
                    $respTabs.find('.resp-tab-content1').each(function() {
                        $tabContent = $(this);
                        $tabContent.attr('aria-labelledby', 'tab_item-' + (tabcount));
                        tabcount++;
                    });
                    count++;
                });

                //Tab Click action function
                $respTabs.find("[role=tab]").each(function() {
                    var $currentTab = $(this);
                    $currentTab.click(function() {

                        var $tabAria = $currentTab.attr('aria-controls1');

                        if ($currentTab.hasClass('resp-accordion1') && $currentTab.hasClass('resp-tab-active1')) {
                            $respTabs.find('.resp-tab-content-active1').slideUp('', function() {
                                $(this).addClass('resp-accordion-closed1');
                            });
                            $currentTab.removeClass('resp-tab-active1');
                            return false;
                        }
                        if (!$currentTab.hasClass('resp-tab-active1') && $currentTab.hasClass('resp-accordion1')) {
                            $respTabs.find('.resp-tab-active1').removeClass('resp-tab-active');
                            $respTabs.find('.resp-tab-content-active1').slideUp().removeClass('resp-tab-content-active resp-accordion-closed1');
                            $respTabs.find("[aria-controls=" + $tabAria + "]").addClass('resp-tab-active1');

                            $respTabs.find('.resp-tab-content1[aria-labelledby = ' + $tabAria + ']').slideDown().addClass('resp-tab-content-active1');
                        }
                        else {
                            $respTabs.find('.resp-tab-active1').removeClass('resp-tab-active1');
                            $respTabs.find('.resp-tab-content-active1').removeAttr('style').removeClass('resp-tab-content-active1').removeClass('resp-accordion-closed1');
                            $respTabs.find("[aria-controls=" + $tabAria + "]").addClass('resp-tab-active1');
                            $respTabs.find('.resp-tab-content1[aria-labelledby = ' + $tabAria + ']').addClass('resp-tab-content-active1').attr('style', 'display:block');
                        }
                        //Trigger tab activation event
                        $currentTab.trigger('tabactivate1', $currentTab);
                    });
                    //Window resize function                   
                    $(window).resize(function() {
                        $respTabs.find('.resp-accordion-closed1').removeAttr('style');
                    });
                });
            });
        }
    });
})(jQuery);