$(function() {
    // dashboard init functions
    altair_dashboard.init();
});

altair_dashboard = {
    init: function() {
        'use strict';

        // small charts
        // altair_dashboard.peity_charts();
        // large graph
        altair_dashboard.metrics_charts();
        // large graph
        // altair_dashboard.chartist_charts();
        // video player
        // altair_dashboard.video_player();
        // calendar
        // altair_dashboard.clndr_calendar();
        // google maps
        // altair_dashboard.maplace_maps();

        // run animations after page is fully loaded
        $window.on('load', function() {
            // altair_dashboard.circular_statistics();
            altair_dashboard.count_animated();
        });
    },
    // metrics-graphics
    metrics_charts: function() {
        var mGraph_sale = '#mGraph_sale';

        if ($(mGraph_sale).length) {

            var $thisEl_height = 0;

            function buildGraph_sale() {

                if ($thisEl_height == 0) {
                    var $thisEl_height = $(mGraph_sale).height();
                }

                var $thisEl_width = $(mGraph_sale).width();

                d3.json("/action/sales_chart", function(data) {
                    data = [data];
                    data.splice(0, 0);
                    console.log(data);
                    for (var i = 0; i < data.length; i++) {
                        data[i] = MG.convert.date(data[i], 'date');
                    }
                    var markers = [
                        {
                            'date': new Date('2016-02-26T00:00:00.000Z'),
                            'label': 'Winter Sale'
                        },
                        {
                            'date': new Date('2016-06-02T00:00:00.000Z'),
                            'label': 'Spring Sale'
                        }
                    ];
                    // add a chart that has a log scale
                    MG.data_graphic({
                        data: data,
                        y_scale_type: 'log',
                        width: $thisEl_width,
                        height: $thisEl_height,
                        right: 20,
                        target: mGraph_sale,
                        markers: null,
                        x_accessor: 'date',
                        y_accessor: 'value'
                    });
                });

            }

            buildGraph_sale();

            $window.on('debouncedresize', function() {
                buildGraph_sale();
            });

            $("#mGraph_sale").on('display.uk.check', function() {
                buildGraph_sale();
            });

        }
    },
    // animated numerical values
    count_animated: function() {
        $('.countUpMe').each(function() {
            var target = this,
                countTo = $(target).text();
            theAnimation = new CountUp(target, 0, countTo, 0, 2);
            theAnimation.start();
        });
    }
};
