$(function() {
    // ckeditor
    altair_wysiwyg._ckeditor();
    // ckeditor inline
    altair_wysiwyg._ckeditor_inline();
    // tinymce
    altair_wysiwyg._tinymce();
});

// wysiwyg editors
altair_wysiwyg = {
    _ckeditor: function() {
        var $ckEditor = $('#wysiwyg_ckeditor, .wysiwyg_ckeditor');
        if ($ckEditor.length) {
            $ckEditor
                .ckeditor(function() {
                    /* Callback function code. */
                }, {
                    customConfig: '../../../admin/assets/js/custom/ckeditor_config.js'
                });
        }
    },
    _ckeditor_inline: function() {
        var $ckEditor_inline = $('#wysiwyg_ckeditor_inline');
        if ($ckEditor_inline.length) {
            console.log($ckEditor_inline);
            $ckEditor_inline
                .ckeditor(function() {
                    /* Callback function code. */
                }, {
                    customConfig: '../../../admin/assets/js/custom/ckeditor_config.js',
                    allowedContent: true
                });
        }
    },
    _tinymce: function() {
        var $tinymce = '#wysiwyg_tinymce';
        if ($($tinymce).length) {
            tinymce.init({
                skin_url: 'lib/admin/assets/skins/tinymce/material_design',
                selector: "#wysiwyg_tinymce",
                plugins: [
                    "advlist autolink lists link image charmap print preview anchor",
                    "searchreplace visualblocks code fullscreen",
                    "insertdatetime media table contextmenu paste"
                ],
                toolbar: "insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image",
                file_picker_callback: elFinderBrowser
            });

            function elFinderBrowser(callback, value, meta) {
                tinymce.activeEditor.windowManager.open({
                    file: '/admin_files/file_manager/fm_tinymce.html', // use an absolute path!
                    title: 'File Manager',
                    width: 920,
                    height: 440,
                    resizable: 'yes'
                }, {
                    oninsert: function(file, elf) {
                        var url, reg, info;

                        // URL normalization
                        url = file.url;
                        reg = /\/[^/]+?\/\.\.\//;
                        while (url.match(reg)) {
                            url = url.replace(reg, '/');
                        }

                        // Make file info
                        info = file.name + ' (' + elf.formatSize(file.size) + ')';

                        // Provide file and text for the link dialog
                        if (meta.filetype == 'file') {
                            callback(url, {
                                text: info,
                                title: info
                            });
                        }

                        // Provide image and alt text for the image dialog
                        if (meta.filetype == 'image') {
                            callback(url, {
                                alt: info
                            });
                        }

                        // Provide alternative source and posted for the media dialog
                        if (meta.filetype == 'media') {
                            callback(url);
                        }
                    }
                });
                return false;
            }

        }
    }
};
